grammar AccessControl;
options {
    language=Python;
    k = 2;
}
@header {
from dtel.DTELSpecification import DTELSpecification
from dtel.TypeDeclaration import TypeDeclaration
from dtel.TypeAssignment import TypeAssignment
from dtel.EntryPointAttribute import EntryPointAttribute
from dtel.Domain import Domain
from dtel.FilePermissionSet import FilePermissionSet
from dtel.PermissionAttribute import PermissionAttribute
from dtel.TransitionAttribute import TransitionAttribute

from mls.MLSSpecification import MLSSpecification
from mls.MLSAssignment import MLSAssignment
from mls.MLSUserDeclaration import MLSUserDeclaration
 
from util.DTELError import DTELError
}

@members {
	def  parsePermissions(self, perms,  flags,  line,  column)  :
	     i = 0
	     for flag in flags :
	         if flag == 'r' :  perms.setReadPermission()
	         elif flag == 'w': perms.setWritePermission()
	         elif flag == 'x':  perms.setExecPermission()
	         elif flag ==  'c': perms.setCreatePermission()
	         elif flag ==  'd': perms.setDirPermission()
	         else: raise DTELError("Encountered "+flag+"at line "+line+", column "+(column+i)+".\nWas expecting one of: c,r,w,x,d")
	         i = i + 1
}

accessControlSpec returns [spec]
	: (data =  dtelSpec
	   | data =  mlsSpec)
	{
	   $spec = $data.spec
	}
	;

dtelSpec returns[spec]
@init {
  typeAssignments = []
  domains =[]
  types = []
}
	: (
		typeDecl = dtelType
		{
			types.append($typeDecl.dType)
		}
	  )+ 
	  (
	  	dom = dtelDomain
	  	{
	  		domains.append($dom.domain)
	  	}
	  )+ 
	 initialDomain = dtelInitial 
	  (
	  	assign = dtelAssign
	  	{
	  		typeAssignments.append($assign.typeAssign)
	  	}
	  )+
	  {
	  	spec = DTELSpecification(types,domains,typeAssignments,$initialDomain.domain)
	  }
	;
	
dtelType returns [dType]
	: 'type' typeList = idList ';'
	{
		 dType = TypeDeclaration($typeList.list)
	}
	;
	
idList returns [list]
@init {
	list = []
}
	: id = ID 
		{
			list.append($id.text)
		}
	  (',' id = ID
	  	{
	  		list.append($id.text)
	  	}
	  )*
	;
	
dtelDomain returns [domain]
@init {
	entryPoints = []
	permissions = []
	transitions = []
	setauth = False
}
	: 'domain' domainName = ID '=' '(' paths = pathList ')'
	{
		for path in $paths.list : 
    		entryPoints.append(EntryPointAttribute(path))
  	}
	 ( ',' '(' ( permission = permissionAttr
					 	{
					 		permissions.append($permission.permAttr)
					 	}
	 				 | transition =  transitionAttr
						{
					 		transitions.append($transition.transition)
					 	}
			 ) ')'
	 )*
  	 ( (',' 'setauth')
  	   {
  	     setauth = True
  	   }
  	   	( ',' '(' ( permission = permissionAttr
					 	{
					 		permissions.append($permission.permAttr)
					 	}
	 				 | transition =  transitionAttr
						{
					 		transitions.append($transition.transition)
					 	}
			 ) ')'
	 )* )? ';'
  {
	domain =  Domain($domainName.text,entryPoints,permissions,transitions,setauth)
  }
    ;

permissionAttr returns [permAttr]
@init {
	perms = FilePermissionSet()
}
	: flags = ID '->' types =  idList
	{
		self.parsePermissions(perms,$flags.text,$flags.line,$flags.pos)
		permAttr = PermissionAttribute(perms,$types.list)
	}
 	;

transitionAttr returns [transition]
@init {
	auto = False
	exe = False
}
	: ( 'auto'
			{
				auto = True 
			}
			| 'exec'
			{
				exe = True
			}
		) '->' domains =  idList
		{
			transition = TransitionAttribute(auto,exe,$domains.list)
		}
	;
 
dtelInitial returns [domain]
	: 'initial_domain' '=' id = ID ';'
	{
		domain = $id.text
	}
	;

dtelAssign returns [typeAssign]
@init {
	recursiveOpt = False
	staticOpt = False
}
	: 'assign' 
	('-r'
		{
			recursiveOpt = True
		}
	)? 
	('-s'
		{
			staticOpt = True
		}
	)? typeName = ID paths = pathList ';'
	{
		typeAssign = TypeAssignment($typeName.text,recursiveOpt,staticOpt,$paths.list)
	}
	; 

pathList returns [list]
@init {
	list = []
}
	: pathNames =  path
	{
		list.extend($pathNames.paths)
	} 
	( ',' pathNames = path
	{
		list.extend($pathNames.paths)
	} 
	)*
	;

path returns [paths]
@init {
	paths = []
	suffixes = []
}
	: prefix = PATHPREFIX ( '{' suffixes = idList '}')?
	{
		if len($suffixes.list) == 0 : paths.append($prefix.text)
		else :
			if $prefix.text[len($prefix.text)-1] == '/' :
				for id in $suffixes.list :
					paths.append($prefix.text + id)
			else :
				raise DTELError('Encountered { at line '+$prefix.line+', column '+$prefix.pos+'. Expected /')
	}
	;
	
mlsSpec returns [spec]
	: clearances = mlsClearances categories = mlsCategories assignments = mlsAssigns users = mlsUsers
	   {
	   	   spec = MLSSpecification($clearances.clearanceList, $categories.categoryList, $assignments.assignDecls,$users.userDecls)
	   }
	;
	
mlsClearances returns [clearanceList]
@init {
	clearanceList = []
}
	: 'clearances' ':'
	  clearance = ID 
	   {
	   	   clearanceList.append($clearance.text)
	   }
	  ('<' clearance = ID
	   {
	   	   clearanceList.append($clearance.text)
	   }
	  )*
	;
	
mlsCategories returns [categoryList]
	: 'categories' ':' categories =  idList
	   {
	   	   categoryList = $categories.list
	   }
	;
	
mlsAssigns returns [assignDecls]
@init {
	assignDecls = []
	recursive = False
}
	: ( 
	       'assign' clearance = ID ':' 
	        category = ID 
           {
               categorySet = set()
               categorySet.add($category.text)
           } 
        (':'otherCategory =  ID
           {
               categorySet.add($otherCategory.text)
           }
         )*  
         ('-r'
            {
            	recursive = True
            }
         )?
          paths = pathList
            {
            	for path in paths :
            	   assignDecls.append(MLSAssignment(path,$clearance.text,categorySet,recursive))
            }
      )+
	;
	
mlsUsers returns [userDecls]
@init {
	userDecls = []
}
	: (
	   'users' clearance = ID ':' 
	   category = ID 
	       {
	       	   categoryList = []
	       	   categoryList.append($category.text)
	       } 
	    (':'otherCategory =  ID
	       {
	       	   categoryList.append($otherCategory.text)
	       }
	     )* 
	    userList = idList
	       {
	       	   for user in userList :
	       	       userDecls.append(MLSUserDeclaration(user,$clearance.text,categoryList))
	        }
	     )+
	;
	
ID  :	('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'0'..'9'|'_')*
    ;

INT :	'0'..'9'+
    ;

COMMENT
    :   '#' ~('\n'|'\r')* '\r'? '\n' {$channel=HIDDEN;}
    |   '/*' ( options {greedy=false;} : . )* '*/' {$channel=HIDDEN;}
    ;

WS  :   ( ' '
        | '\t'
        | '\r'
        | '\n'
        ) {$channel=HIDDEN;}
    ;

PATHPREFIX : ('/' | ('/' ID)+ ('/')?)
	;
