'''
Created on Oct 23, 2012

A node in the clearance, category set security level lattice
@author: carr
'''
    
class LatticeNode(object):
 
    def __init__(self,clearance,category):
        '''
        :param clearance: a clearance level
        :param category: a category set
        '''
        self.clearance = clearance
        self.category = category
        self.preds = set() # predecessors in the lattice
        self.succs = set() # successors in the lattice
        self.walkFlag = False # used for walking the lattice
        self.predStr = "" # a string representation of a nodes predecessors
        self.succStr = "" # a string representation of a nodes successors
        #self.name = ""
        
    def getClearance(self): return self.clearance
    def getCategory(self): return self.category
    def sameSecurityLevel(self,clearance,category) : return clearance == self.clearance and category == self.category
    
    def isPredecessor(self,node): return node in self.preds
    def isSuccessor(self,node): return node in self.succs        
        
    def addPredecessor(self,pred):
        self.preds.add(pred)
        
    def addSuccessor(self,succ):
        self.succs.add(succ)
        
    def getNodeIdString(self):
        return "("+self.clearance+","+str(self.category)+")"
    
    def getPredecessorIdString(self):
        if self.predStr == "" : 
            for node in self.preds :
                self.predStr =self.predStr+ " " + node.getNodeIdString()
        return self.predStr;
    
    def getSuccessorIdString(self):
        if self.succStr == "" : 
            for node in self.succs :
                self.succStr =self.succStr+ " " + node.getNodeIdString()
        return self.succStr;  