'''
Created on Oct 14, 2012

A transition attribute for a domain specification
@author: Carr
'''

EXEC = 1 # exec transition requiring authentication
AUTO = 2 # auto transition w/o authentication

class TransitionAttribute(object):
  

    def __init__(self, auto, exe, domains) :
        '''
        
        :param auto: is this an auto transition
        :param exe: is this an exec transition
        :param domains: the domains to transition to
        '''
        self.auto = auto;
        self.exe = exe;
        self.domains = domains
    
    
    def getTransTypeRep(self) :  
        '''
        Return the transition type
        '''
        if self.auto : return AUTO 
        else : EXEC
        
    def getDomains(self) : return self.domains