'''
Created on Oct 10, 2012

A file system directory tree used to hold dte or mls assignment information

@author: carr
'''

from DirTreeInteriorNode import DirTreeInteriorNode
from DTELError  import DTELError

class DirTree(object):

    def __init__(self):
        '''
        Constructor
        '''
        self.root = None
        
    def getRoot(self) :
        return self.root
    
    def addPath(self, path) :
        '''
        Add a path to the directory tree
        :param path: a file system fully qualified path
        '''
        
        if path[0] == "/" :
            if self.root == None :
                self.root = DirTreeInteriorNode("")
            path = path[1:len(path)]
            self.root.addToTree(path)
        else :
            raise DTELError("Invalid path: "+path)

    def findSubTree(self, path):
        '''
        Find the sub tree representing a particular file system path
        :param path: a fully qualified file system path
        '''
        
        if path[0] == "/" :
            path = path[1:len(path)]
            if path== self.root.getName() :
                return self.root   
            else :
                return self.root.findSubTree(path)
        else :
            raise DTELError("Invalid path: "+path)
        
    def assignTypeToSubtree(self, path, typeId, flags) :
        '''
        Assign a type to a subtree in the directory tree
        :param path: The path to the root of the subtree
        :param typeId: the unique id associated with a type
        :param flags: is the assignment static or recursive
        '''
        node = self.findSubTree(path)
        if node != -1 :
            node.assignType(typeId,flags)

    def assignLevelToSubtree(self, path, levelId, flags) :
        '''
        Assign a clearance,category security level to a subtree in the directory tree
        :param path: The path to the root of the subtree
        :param levelId: the security level unique identifier
        :param flags: is the assignment recursive
        '''
        node = self.findSubTree(path)
        if node != -1 :
            node.assignSecurityLevel(levelId,flags)
            
    def printTree(self) :
        '''
        Print the nodes in the directory tree
        '''
        self.root.printNodes()
        