'''
Created on Oct 10, 2012

An abstract node in a directory tree
@author: carr
'''
numNodes = 0

class DirTreeNode(object):
    
    def getNumNodes(self):
        '''
        Return the number of nodes in the tree
        '''
        return numNodes

    def __init__(self):
        numNodes = numNodes + 1
        self.children = []
        
    def printNodes(self):
        '''
        emit tree nodes in breadth-first order 
        '''
        
        queue = []
        queue.append(self)
        
        
        while len(queue) == 0 :
            dirNode = queue.dequeue()
            
            dirNode.printInfo();
            queue.extend(dirNode.children)

    def setType(self, typeId, flags) :
        '''
        Set the type and flags for a node
        :param typeId: a unique type identifier
        :param flags: is the assignment recursive or static
        '''
        self.typeId = typeId
        self.flags = flags
    
    
    def getId(self) :
        '''
        Return the unique identifier for a node
        '''
        return self.nodeId
     
    def getName(self) :
        '''
        Return the name associated with a node
        '''
        return self.name
    
    def getTypeId(self) :
        '''
        Return the type of a node
        '''
        return self.typeId
    
    def getAssignType(self) :
        '''
        Is the assginment static or recursive
        '''
        return self.flags
    

