'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Man Wang
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''

'''
Created on Oct 14, 2012

Parse and process an access control specification
@author: Carr
'''
from  dtel.DTELSpecification import DTELSpecification
from  mls.MLSSpecification import MLSSpecification
import sys
import string
import antlr3
from  aparser.AccessControlLexer  import AccessControlLexer
from  aparser.AccessControlParser import AccessControlParser

class AccessControlMain():
    
    def __init__(self, inputDir, outputDir):
        char_stream = antlr3.ANTLRFileStream(inputDir)
        lexer =AccessControlLexer(char_stream)
        tokens = antlr3.CommonTokenStream(lexer)
        aparser = AccessControlParser(tokens)
        accessControl =  aparser.accessControlSpec()
        accessControl.printLatticeToFile(outputDir)
 
    