'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Man Wang
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on 2013-03-13

@author: mandy
'''
from TypeNode import TypeNode
from EdgeItem import EdgeItem
from FileNode import FileNode
import string

class AddItemsIntoScene(object):

    def __init__(self, scene, iohelper):
        self.scene = scene
        self.iohelper = iohelper
        self.initParam()
        
    def initParam(self):
        self.first = None
        self.last = None
        self.NdsLevels = self.scene.NdsLevels
        self.numNdsLevel = 0     
        self.fileNodes = []
        
    def addUserNode2Scene(self):
        self.userNodes = self.iohelper.userNodes
                
    def removeTransEdge(self):
        for e in self.iohelper.latticeNodes:
            if e.parent == []:
                self.first = e
            elif e.children == []:
                self.last = e

        item = self.first
        self.NdsLevels = {0:[item]}
        self.numNdsLevel+=1
        
        prevlevel = 0
        i, j = 0, 0
        var =[]
        while item != self.last:
            tempChildren = []
            for e in item.children:
                tempChildren.append(e)
            for c in item.children:
                for cc in c.children:
                    for e in item.children:
                        if e == cc: 
                            tempChildren.remove(e)
                item.children = tempChildren
            if i < len(self.NdsLevels[prevlevel]):
                for ele in item.children:
                    if ele.visited == False:
                        var.append(ele)
                        ele.visited = True
                i+=1
            if i == len(self.NdsLevels[prevlevel]):
                self.NdsLevels.update({self.numNdsLevel:var})
                self.numNdsLevel+=1
                prevlevel +=1
                var = []
                j = 0
                i = 0
            if self.NdsLevels[self.numNdsLevel-1][j] != None:
                item = self.NdsLevels[self.numNdsLevel-1][j]
                j += 1
        #get the break up level
        for i in xrange(0, len(self.NdsLevels)-1):
            current = len(self.NdsLevels[i])
            next = len(self.NdsLevels[i+1])
            if current > next:
                self.scene.brkLevel = i+1
                break
            current = next
        self.scene.NdsLevels = self.NdsLevels
#        for i in xrange(len(self.NdsLevels)):
#            for n in self.NdsLevels[i]:
#                print i, n.name
        
    def getNodeLevel(self):
        node = self.scene.firstNode
        childrenList = node.children
        self.NdsLevels = {0:[node]}
        level = 1
        while node != self.scene.lastNode:
            onelevelNodes = []
            tempOnelevelChildren = []
#             '''
#             '''
#             nextLevelChildren = set()
#             for item in childrenList:
#                 nextLevelChildren = nextLevelChildren.union(set(item.children))
#                 self.NdsLevels.update({level:childrenList})
#                 childrenList= list(nextLevelChildren)
#             level+=1
#             '''
#             '''
            for item in childrenList:
                onelevelNodes.append(item)
                node = item
                for c in item.children:
#                     print item.clearance, item.category, c.clearance, c.category
                    if c not in tempOnelevelChildren:
                        tempOnelevelChildren.append(c)
            self.NdsLevels.update({level:onelevelNodes})
            childrenList = tempOnelevelChildren
            level += 1
        self.scene.NdsLevels = self.NdsLevels
#         for l in self.NdsLevels.keys():
#             for e in self.NdsLevels[l]:
#                 print l, e.name
                
    def getEdgeItem(self):
        self.removeTransEdge()
       
    def getFileNodes(self):
        self.fileNodes = []
        for v in self.iohelper.typeNodes:
#             print 'typeNodes', v.name, v.dir
            self.iohelper.createFileNodes(v)
        self.iohelper.generateFileNodeParentChildren()
        self.iohelper.buildFileNodeHierarchy()
        #print 'filenode', e.name, e.parentName, e.fullPath, e.type.name
