'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Man Wang
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on 2013-02-07

@author: mandy
'''
from PyQt4.QtGui import QGraphicsItem, QGraphicsEllipseItem, QBrush, QPen, QColor, QGraphicsPixmapItem
from PyQt4.QtCore import Qt, QObject
from commonFunction import Functions

class ClearanceNode(QGraphicsEllipseItem):
    LABELHEIGHT = 20
    def __init__(self,clearance,category, scene):
        QObject.__init__(self)
        QGraphicsEllipseItem.__init__(self)
        self.setRect(-5,-5,10,10)
        self.setFlag(QGraphicsItem.ItemIsMovable, True)
        self.setFlag(QGraphicsItem.ItemIsSelectable, True)
        self.brush = QBrush(QColor(255, 255, 0))
        self.oldbrush = QBrush(QColor(255, 255, 0))
        self.pen = None
        self.setAcceptHoverEvents(True);
        self.edgeList = []
        self.leaves = 0
        self.clearance = clearance
        self.flgClr = -1
        self.relatedUsers = 'None'
#        self.categoryStr = ''
        self.category = category
        self.categoryNumStr = '('
        self.level = 0
        self.parent = [] # predecessors in the lattice
        self.children = [] # successors in the lattice
        self.childrenPath = []
        self.childrenOneNode = []
        self.userNodes = set()
        self.movedPos = False

        self.predStr = "" # a string representation of a nodes predecessors
        self.succStr = "" # a string representation of a nodes successors
        self.tempPreds = []
        self.tempSucces = []
        self.name = ''
        self.visited = False
        self.scene = scene
        
        self.color = None
        self.highlighted = False
        self.firstSecondNode = False
        self.highlightColor = QColor(0, 0, 255)
        self.clicked = False
        self.clickColor = QColor(255, 0,0)
        self.selected = False
        self.drawShawdow = False
        self.displayLabel = True
        self.labelRect = None
        self.label = ''
        
        self.rootNode = False
        self.leafNode = False
        
        self.groupingNode = False
        self.groupingChildrenPath = []
        self.groupingParentPath = []
        self.groupingOriChildrenPath = []
        self.firstCompute = True
        self.cateOdreSum = len(category)
        
    def paint(self, painter, option, widget=None):
        if self.firstCompute:
            color0, color1, color2 = Functions.colorMapping(self.clearance, self.scene.clearances)
            self.color = QColor(color0, color1, color2, 255)
            self.brush = QBrush(self.color)
             
            if self.groupingNode:
                self.pen = QPen(QColor(0.8*self.color.red(), 0.8*self.color.green(), 0.8*self.color.blue(), 255))
                self.pen.setWidth(3.0)
            elif self.groupingParentPath != []:
                if self.groupingParentPath[0].groupingNode:
                    self.pen = QPen(QColor(0.8*color0, 0.8*color1, 0.8*color2, 255))
                    self.pen.setWidth(3.0)
            else:
                self.pen = QPen(QColor(1, 0, 0))
                self.pen.setWidth(1.0)
             
        self.setBrush(self.brush)
        self.setPen(self.pen)
        QGraphicsEllipseItem.paint(self, painter, option, widget)
        #labels
        font = self.scene.font()
        font.setPixelSize(15)
        painter.setFont(font)
         
        if self.firstCompute:
            Functions.computeCateNum(self,self.scene.categories)
            if (self.rootNode or self.leafNode) and (self.categoryNumStr.find('\n') != -1):
                self.labelRect = painter.fontMetrics().boundingRect(self.categoryNumStr[:self.categoryNumStr.find('\n')])
                self.label = self.categoryNumStr
            else:
                if self.groupingNode:
                    self.label = str(len(self.groupingChildrenPath))
                else:
                    self.label = self.categoryNumStr
                self.labelRect = painter.fontMetrics().boundingRect(self.label+'  ')
             
            self.labelRect.setHeight(self.LABELHEIGHT)
             
        if self.displayLabel:
            if self.rootNode:
                x = int(self.rect().topLeft().x()-self.labelRect.width()-10)
                y = int(self.rect().topLeft().y()-self.rect().height()*0.5)
            else:
#                x = int(self.rect().topLeft().x()+self.boundingRect().width()+10)
#                y = int(self.rect().topLeft().y())
                x = int(self.rect().bottomLeft().x()-0.5*(self.labelRect.width()-self.rect().width()))
                y = int(self.rect().topLeft().y()-self.labelRect.height())
            self.paintLabel(painter, self.oldbrush, x, y)
 
#         if self.highlighted:
#             self.highlightColor = QColor(255,0,0)
# #        if self.firstSecondNode:
# #            self.highlightColor = QColor(0,0,0)
#             
#             painter.save()
#             painter.setPen(QPen(QBrush(self.highlightColor), 2.0))
#             painter.setBrush(Qt.NoBrush)
#             painter.drawRect(self.rect().adjusted(-5, -5, 5, 5))
#             painter.restore()
        
        if self.firstSecondNode:
            self.clickColor = QColor(0,0,0)
            painter.save()
            painter.setPen(QPen(QBrush(self.clickColor), 2.0))
            painter.setBrush(Qt.NoBrush)
            painter.drawRect(self.rect().adjusted(-5, -5, 5, 5))
            painter.restore()
            
        self.firstCompute = False
        self.prevPos = self.pos()
                    
    def paintLabel(self, painter, oldbrush, x, y):
        painter.save()
        rect = self.labelRect
        rect.moveTo(x, y)
        painter.drawText(rect, Qt.AlignLeft, self.label)
        painter.restore()

    def itemChange(self, change, value):
        if change == QGraphicsItem.ItemPositionChange:
            for edge in self.edgeList:
                edge.updatePosition()
        return value 
            
    def hoverEnterEvent(self, evt):
#        self.scene().hoverItem = selfdrawRect
        self.scene.hoverItem = self
        self.drawShawdow = True
        QGraphicsEllipseItem.hoverEnterEvent(self, evt)
        
    def hoverLeaveEvent(self, evt):
        self.scene.hoverItem = None
        self.drawShawdow = False
        QGraphicsEllipseItem.hoverLeaveEvent(self, evt)
    
    def getClearance(self): 
        return self.clearance
    
    def getCategory(self): return self.category
    
    def sameSecurityLevel(self,clearance,category) : return clearance == self.clearance and category == self.category
    
    def isPredecessor(self,node): return node in self.parent
    def isSuccessor(self,node): return node in self.children        
        
    def addPredecessor(self,pred):
        self.parent.append(pred)
        
    def addSuccessor(self,succ):
        self.children.append(succ)
        
    def getNodeIdString(self):
        return "("+self.clearance+","+str(self.category)+")"
    
    def getPredecessorIdString(self):
        if self.predStr == "" : 
            for node in self.parent :
                self.predStr =self.predStr+ " " + node.getNodeIdString()
        return self.predStr
    
    def getSuccessorIdString(self):
        if self.succStr == "" : 
            for node in self.children :
                self.succStr =self.succStr+ " " + node.getNodeIdString()
        return self.succStr