'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Man Wang
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on Oct 13, 2013

@author: mandy
'''
from PyQt4.QtGui import QMessageBox, QFileDialog, QApplication
from PyQt4.QtCore import QObject, QPointF, QString, QRect, QFileInfo, QFile
from AddItemsIntoScene import AddItemsIntoScene
from commonFunction import Functions
from TypeNode import TypeNode
from UserNode import UserNode
from EdgeItem import EdgeItem
from FileNode import FileNode
from ClearanceNode import ClearanceNode
import string

class DiagramIOHelper(object):

    def __init__(self, scene):
        self.scene = scene
        self.add2Scene = AddItemsIntoScene(self.scene, self)
        self.initParam()
        
    def initParam(self):  
        self.latticeNodes = []
        self.wholelatticeNodes = []
        self.typeNodes = []
        self.userNodes = []
        self.add2Scene.initParam() 
        self.individualUserNode = {}
        
    def getListFromString(self, aString):
        aString =   aString.replace('[', '')
        aString =   aString.replace(']', '')
        aString =   aString.replace("'", "")
        aString =   aString.replace(' ', '')
        return aString.split(',')
    
    def findClrNodeInList(self, clearance, cateset, nodeList):
        if cateset == set():
                cateset = set([''])
        for n in nodeList:
            if clearance == n.clearance and cateset == set(n.category):
                return n
        return None
        
    def createClearanceNode(self, name,clearance, category):   
        cate = self.getListFromString(category)
        node = ClearanceNode(clearance, cate, self.scene)
        node.name = name
        node.flgClr = self.getClearanceFlg(node)
        return self.findClrNodeInList(node.clearance, set(node.category), self.latticeNodes)
    
    def createUserNode(self, name, clearance, category):
        node = self.findClrNodeInList(clearance, set(category), self.latticeNodes)
        unode = UserNode(name, node, self.scene)
        node.userNodes.add(unode)
        self.userNodes.append(unode)
        
    def getAssignedFlag(self, type, typeNode):
        if type == '-r -s':
            typeNode.flag = 3
        elif type == '-r':
            typeNode.flag = 2
        elif type == '-s':
            typeNode.flag = 1
        else:
            typeNode.flag = 0
            
    def getAssignedDir(self, str, typeNode):
        str = str.strip('\n')
        if str != '/' and str[-1] == '/':
            str = str[:-1]
        typeNode.dir.append(str)
    
    def duplicationFileNode(self, fileNode):
        for f in self.add2Scene.fileNodes:
            if fileNode.name == f.name and fileNode.parentName == f.parentName:
                return True
        return False
    
    def createFileNodes(self, v):
        if v.dir == ['/']:
            fileNode = FileNode('', None, -1)
            fileNode.setVisible(False)
            fileNode.parent = None
            fileNode.parentName = None
            fileNode.name = ''
            fileNode.fullPath = '/'
            fileNode.flag = v.flag
            fileNode.type = v
            fileNode.explicitAssign = True
            exist = self.duplicationFileNode(fileNode)
            if not exist: 
                self.add2Scene.fileNodes.append(fileNode)
                self.scene.addItem(fileNode)
        else:
            for d in v.dir:
                listtmp = d.split('/')
                for i in xrange(0, len(listtmp)):
                    fileNode = FileNode('', None, -1)
                    fileNode.setVisible(False)
                    fileNode.parent = None
                    fileNode.name = listtmp[i]
                    fileNode.fullPath = ''
                    for j in xrange(i+1):
                        if fileNode.fullPath != '/':
                            fileNode.fullPath += '/'
                        fileNode.fullPath+=listtmp[j]
                    if i == len(listtmp)-1:
                        fileNode.flag = v.flag
                        fileNode.type = v
                        fileNode.explicitAssign = True
                    if fileNode.name != '':
                        fileNode.parentName = listtmp[i-1]
                    else:
                        fileNode.parentName = None
                    exist = self.duplicationFileNode(fileNode)
                    if not exist:
                        self.add2Scene.fileNodes.append(fileNode)
                        self.scene.addItem(fileNode)
                    else:
                        for f in self.add2Scene.fileNodes:
                            if f.fullPath==d:
                                f.flag = v.flag
                                f.type = v
                                
    def generateFileNodeParentChildren(self):
        for e in self.add2Scene.fileNodes:
            for n in self.add2Scene.fileNodes:
                if  e.parentName == n.name:
                    e.parent = n
                    if e not in n.children:
                        n.children.append(e)
                    
        for e in self.add2Scene.fileNodes:
            if e.parent == None:
                self.scene.typeGraphRoot = e
            else:
                parent = e.parent
                while parent and 'explicitAssign' not in parent.__dict__:
                    parent = parent.parent
                e.inheritFromNode = parent
    
    def buildFileNodeHierarchy(self):
        for e in self.scene.items():
            if isinstance(e, EdgeItem) and e.type == EdgeItem.FILE_CONN:
                self.scene.removeItem(e)
        if self.scene.typeGraphRoot:
            treeNodes = [self.scene.typeGraphRoot]
            options = Functions.flag2Option(treeNodes[0].flag)
            if treeNodes[0].type != None:
                treeNodes[0].type.assignment += '%s /;' % options
            
            while treeNodes:
                node = treeNodes[0]
                node.edgeList = []
                for child in node.children:
                    options = Functions.flag2Option(child.flag)            
                    if child.type!= None and child.type.assignment == '':
                        if child.inheritFromNode is None:
                            child.type.assignment += '%s %s;' % (options, child.fullPath)
                    else:
                        if child.type!= None and child.inheritFromNode is None:
                            components = string.split(child.type.assignment, ';')
                            for i, component in enumerate(components):
                                if components == '':
                                    continue
                                if component.find(options) != -1:
                                    components[i] += ', %s' % child.fullPath
                                    break
                            child.type.assignment = ';'.join(components)
                    e = EdgeItem(EdgeItem.FILE_CONN, node, child)
                    node.edgeList.append(e)
                    child.edgeList.append(e)
                    e.startItem=node
                    e.endItem=child
                    self.scene.addItem(e)
                    e.setVisible(False)
                    if child.children:
                        treeNodes.append(child)
                treeNodes.pop(0)
        else:
            self.scene.typeGraphRoot = FileNode('', None, 2)
            self.scene.typeGraphRoot.setVisible(False)
#        for item in self.fileNodes:
#            print item.name, item.fullPath
#            if item.parent:
#                print 'parent', item.parent.name, item.parent.fullPath
        
    def addTypeNode2Scene(self):
        numTypeNode = len(self.typeNodes)
        if numTypeNode == 0:
            return
        numColorsInTable=len(TypeNode.ColorTable)
        step = (numColorsInTable-1)/numTypeNode
        for i in xrange(numTypeNode):
            self.typeNodes[i].color = TypeNode.ColorTable[(i+1)*step]
            if self.typeNodes[i] not in self.scene.items():
                self.scene.addItem(self.typeNodes[i])
            
#        k = 0
#        for i in xrange(0,len(self.typeNodes)):
#            for j in xrange(0, i+1):
#                if (j < i) and (self.typeNodes[j].name == self.typeNodes[i].name):
#                    self.typeNodes[i].color = self.typeNodes[j].color
#                    break
##                if j==i:
##                    self.typeNodes[i].color = TypeNode.ColorTable[k]
##                    if self.typeNodes[i] not in self.scene.items():
##                        self.scene.addItem(self.typeNodes[i])
##                    k+=1
#                if j==i:
#                    self.typeNodes[i].color = TypeNode.ColorTable[k]
#                    if self.typeNodes[i] not in self.scene.items():
#                        self.scene.addItem(self.typeNodes[i])
#                    k+=1
        self.typeNodes.sort(key =lambda x: x.dir[0].count('/'))
        self.scene.main.computeTypeGraph = 0
 
    def drawClearanceNode(self, node, users):
        if self.scene.growLevelLayout.firstNode == None:
            node = self.scene.growLevelLayout.initialNodes(node)
            if users != 'None':
                node.relatedUser = users
                node.highlighted = True
#            self.scene.predSuccList.listWidget.clear()
#            self.scene.predSuccList.listWidget.addItem(node.name)
            self.scene.growLevelLayout.firstNode = node
            self.scene.growLevelLayout.mergedNdlvl = [[node]]
            for i in xrange(len(self.scene.NdsLevels)):
                if node in self.scene.NdsLevels[i]:
                    self.scene.growLevelLayout.mergedNdlvlDictionary = {i:[node]}
                    self.scene.growLevelLayout.nodeListKeyIncreasing = [i]
            self.scene.growLevelLayout.onelevelExtend = [[node]]
        else:
            reached = False
            for elist in self.scene.NdsLevels.values():
                for e in elist:
                    if e.clearance == node.clearance and set(e.category) == set(node.category):
                        node = e
                        if users != 'None':
                            node.relatedUser = users
                            node.highlighted = True
            if node not in self.scene.items():
                self.scene.growLevelLayout.addOneNode2Scene(node, False)
                reached = self.scene.growLevelLayout.setupConnectionWithOtherNodes(node, self.scene.growLevelLayout.mergedNdlvlDictionary)
                if reached:
                    self.scene.growLevelLayout.removeRedundantEdges()
                self.scene.growLevelLayout.appendNodeInList(node, self.scene.layout.E, self.scene.growLevelLayout.mergedNdlvlDictionary)
            #self.scene.growLevelLayout.equalWidthIntvlOneNodeLayout(self.scene.growLevelLayout.mergedNdlvlDictionary)
            self.scene.growLevelLayout.equalWidthIntvlOneNodeLayoutNorthSouth(self.scene.growLevelLayout.mergedNdlvlDictionary)
        return node
    
    def import_(self, specDir, parsedDir):
        self.initParam()
        self.getTypeNodes(specDir)
        self.getLatticeNode(parsedDir)
        self.getUserNodes(specDir)
        self.addTypeNode2Scene()
        self.add2Scene.getEdgeItem()
        self.add2Scene.getFileNodes()
        self.scene.categoryCombination = Functions.allCateCombination(self.scene.categories)
    
    def export(self, specFileDir):
        self.scene.spec = self.scene.securitySpec+'\n'+self.scene.typeAssign+'\n'+self.scene.usrAssign
        with open(specFileDir, 'w') as f:
            lines  = self.scene.spec.split('\n')
            for l in lines:
                f.write('%s\n'% l)
        f.close()
            
    def read(self, filename):
        self.scene.main.initParam()
        with open(filename, 'r') as f:
            self.scene.main.hasInfo = True
            self.scene.spec = ''
            oneline = f.readline()
            clearances = oneline.split(' ')
            self.scene.newClearance = clearances[1:len(clearances)-1]
            self.scene.clearances = self.scene.newClearance

            oneline = f.readline()
            categories = oneline.split(' ')
            categories = categories[1:len(categories)-1]
            self.scene.newcategoryCombination = Functions.allCateCombination(categories)
            self.scene.categories = categories
            self.scene.main.setupClrCateUI()
            self.setupSecurityHierarchy()
            counter = 0
            map = {}
            for line in f:
                line = line[:line.find('\n')]
                components = line.split(':')
                if components[0] == 'Clr':
                    name = components[1][components[1].find('('):components[1].rfind(')')+1]
                    node = self.createClearanceNode(name, components[2], components[3])
                    node = self.drawClearanceNode(node, components[4])
                    map[counter] = node
                    users = components[4].split(',')
                    users = filter(lambda a: a != '', users)
                    for u in users:
                        unode = UserNode(u, node, self.scene)
                        node.userNodes.add(unode)
                        self.userNodes.append(unode)
                    counter += 1
                    
                elif components[0] == 'Type':
                    cate = self.getListFromString(components[3])
                    typeNode = TypeNode(self.scene.clearances, components[2], cate)
                    typeNode.name = components[1]
                    typeNode.dir = self.getListFromString(components[-2])
                    typeNode.type = int(components[-1])
                    self.getAssignedFlag(typeNode.type, typeNode)
                    self.typeNodes.append(typeNode)
            f.close()
            self.latticeNodes.sort(key =lambda x: x.flgClr, reverse=True)  
            self.scene.wholelatticeNodes = self.wholelatticeNodes
            self.addTypeNode2Scene()
            self.add2Scene.getFileNodes()
            self.scene.main.resizeEvent(None)
            #self.scene.growLevelLayout.equalWidthIntvlOneNodeLayoutNorthSouth(self.scene.growLevelLayout.mergedNdlvlDictionary)
            #self.scene.update()
            
    def write(self, filename):
        generalGraphNodes = {}
        generalGraphEdges = {}
        typeGraphNodes = {}
        typeGraphEdges = {}
        counter = 0
        
        for item in self.scene.items():
            if isinstance(item, ClearanceNode):
                generalGraphNodes[item] = counter
                counter +=1
        for item in self.scene.items():
            if isinstance(item, TypeNode):
                typeGraphNodes[item] = counter
                counter += 1
        
#        for item in self.scene.items():
#            if isinstance(item, FileNode):
#                typeGraphNodes[item] = counter
#                counter += 1
            
        for item in self.scene.items():
            if isinstance(item, EdgeItem):
                if item.type == EdgeItem.CLR_CONN:
                    startId = generalGraphNodes[item.startItem]
                    endId = generalGraphNodes[item.endItem]
                    generalGraphEdges[(startId, endId)] = item
#                elif item.type == EdgeItem.FILE_CONN:
#                    startId = typeGraphNodes[item.startItem]
#                    endId = typeGraphNodes[item.endItem]
#                    typeGraphEdges[(startId, endId)] = item
                    
        with open(filename, 'w') as f:
            f.write('Clearances: ')
            for clr in self.scene.clearances:
                f.write('%s '% clr)
            f.write('\nCategories: ')
            for cat in self.scene.categories:
                f.write('%s '% cat)
            f.write('\n')
            nodes = sorted(generalGraphNodes, key = generalGraphNodes.__getitem__)
            for n in nodes:
                relatedUsers=','.join(u.name for u in n.userNodes)
                f.write('Clr:%s:%s:%s:%s:%f:%f\n' % (n.name, n.clearance, n.category, relatedUsers, n.pos().x(), n.pos().y()))  
                                          
            for k, v in generalGraphEdges.items():
                f.write('GE:%d:%d:%d\n' % (k[0], k[1], v.type))

            nodes = sorted(typeGraphNodes, key = typeGraphNodes.__getitem__, reverse = True)
            for n in nodes:
                if isinstance(n, TypeNode):
                    f.write('Type:%s:%s:%s:%s:%d\n' % (n.name, n.clearance, n.category, n.dir, n.flag))
#                else:
#                    f.write('File:%s:%s:%s:%s:%d\n' % (n.name, n.parentName, , n.fullPath, n.flag))
#                    
#            for k in typeGraphEdges.items():
#                f.write('TE %d %d %d\n' % (k[0], k[1]))
        f.close()
                       
    def getTypeNodes(self, specDir):
        f = open(specDir, 'r')
        lines = f.readlines()
        f.close()
        for i in xrange(0, len(lines)):
            keyword = lines[i].split(' ')[0]
            if keyword.find("clearances:")!=-1:
                self.scene.securitySpec += lines[i]
                self.scene.clearances = Functions.getAllClearanceLevels(lines[i])
            elif keyword.find("categories:")!= -1:
                self.scene.securitySpec += lines[i]
                self.scene.categories = Functions.getAllCategory(lines[i])
            elif keyword == "assign":
                self.scene.typeAssign+=lines[i]
                clearanceSplit = lines[i].strip('assign')
                clearanceSplit = clearanceSplit.replace(' ', '')
                clearanceSplit = clearanceSplit.replace('\t', '')
                if clearanceSplit.find('#')!=-1:
                    clearanceSplit = clearanceSplit[:clearanceSplit.find('#')]
                clearanceSplit = clearanceSplit.split(':')
                category = []
                for j in xrange(1, len(clearanceSplit)):
                    if j != len(clearanceSplit)-1:
                        category.append(clearanceSplit[j])
                    else:
                        if clearanceSplit[j].find('-') != -1:
                            category.append(clearanceSplit[j][:clearanceSplit[j].find('-')])
                            type = clearanceSplit[j][clearanceSplit[j].find('-'):clearanceSplit[j].find('/')]
                        else:
                            category.append(clearanceSplit[j][:clearanceSplit[j].find('/')])
                            type = 0
                        dir = clearanceSplit[j][clearanceSplit[j].find('/'):]
                        dirList = dir.split(',')
                        typeNode = TypeNode(self.scene.clearances, clearanceSplit[0], category)
                        self.getAssignedFlag(type, typeNode)
                        for d in dirList:
                            self.getAssignedDir(d, typeNode)
                        typeNode.name = typeNode.clearance+',set(['
                        for i in xrange(0, len(typeNode.category)):
                            typeNode.name += "'" + typeNode.category[i] + "'"
                            if i != len(typeNode.category)-1:
                                typeNode.name +=','
                        typeNode.name += '])'
                        Functions.computeCateNum(typeNode, self.scene.categories)
                        #typeNode.legendname = typeNode.clearance+','+typeNode.categoryNumStr
                        self.typeNodes.append(typeNode)
        
    def getUserNodes(self, specDir):
        f = open(specDir, 'r')
        lines = f.readlines()
        f.close()
        for i in xrange(0, len(lines)):
            keyword = lines[i].split(' ')[0]
            if keyword == 'users': 
                self.scene.usrAssign += lines[i]
                userLine = lines[i].replace('\t', ' ')
                userLine = userLine[userLine.find(' ')+1:]
                while userLine.find(' ')==0:
                    userLine = userLine[userLine.find(' ')+1:]
                startIndexName = userLine.find(' ')+1
                userName = userLine[startIndexName:]
                if userName.find('\n') != -1:
                    userName = userName[:userName.find('\n')]
                userName = userName.replace(' ', '')
                userLine = userLine[:startIndexName]
                securityInfo = userLine.replace(' ', '')
                users = userName.split(',')
                info = securityInfo.split(':')
                clr = info[0]
                cateList = info[1:]
                for u in users:
                    self.createUserNode(u, clr, cateList)
        
    def getClearanceFlg(self, latticeNode):
        for i in xrange(0, len(self.scene.clearances)):
            if self.scene.clearances[i] == latticeNode.clearance:
                return i
                
    def findPreds(self, predstr):
        predstr = predstr.strip('\n')
        predstr = predstr+' '
        listtmp  = predstr.split(') ')
        for e in listtmp:
            self.latticeNode.tempPreds.append(e+')')
            self.wholelatticeNode.tempPreds.append(e+')')
    
    def findSucces(self, succstr):
        succstr = succstr.strip('\n')
        succstr = succstr+' '
        listtmp  = succstr.split(') ')
        for e in listtmp:
            self.latticeNode.tempSucces.append(e+')')
            self.wholelatticeNode.tempSucces.append(e+')')
                
    def getLatticeNode(self, parsedDir):
        with open(parsedDir, 'r') as f:
            lines=f.readlines()
        f.close()
        for i in xrange(0, len(lines)):
            if lines[i].find("Security Level") != -1:
                latticeNode = ClearanceNode("", [], self.scene)
                latticeNode.name = lines[i][lines[i].find('('):lines[i].rfind(')')+1]
                index = latticeNode.name.find(',')
                latticeNode.clearance = latticeNode.name[:index][1:]
                latticeNode.categoryStr = latticeNode.name[index+1:][:-1]
                str = latticeNode.categoryStr[latticeNode.categoryStr.find("[")+1: latticeNode.categoryStr.rfind("]")]
                str = str.replace("u'","")
                str = str.replace("'", "")
                str = str.replace(" ", "")
                latticeNode.category = str.split(',')
                latticeNode.flgClr = self.getClearanceFlg(latticeNode)
                self.latticeNode = latticeNode
                self.wholelatticeNode = ClearanceNode("", [], self.scene)
                self.wholelatticeNode.name = latticeNode.name
                self.wholelatticeNode.clearance = latticeNode.clearance
                self.wholelatticeNode.category = latticeNode.category
                self.wholelatticeNode.flgClr = latticeNode.flgClr
                self.latticeNodes.append(self.latticeNode)
                self.wholelatticeNodes.append(self.wholelatticeNode)
#             elif lines[i].find("Predecessors")!= -1:
#                 index = lines[i].find('(')
#                 if index != -1:
#                     self.findPreds(lines[i][index:])
#             elif lines[i].find("Successors")!=-1:
#                 index = lines[i].find('(')
#                 if index != -1:
#                     self.findSucces(lines[i][index:])
        for e in self.latticeNodes:
            Functions.addPredsToClearanceNode(e, self.latticeNodes)
            Functions.addSuccesToClearanceNode(e, self.latticeNodes)
#             for u in self.userNodes:
#                 securityInfo = u[1].split(':')
#                 if securityInfo[0] == e.clearance and set(securityInfo[1:]) == set(e.category):
#                     Functions.connectUser2ClrNode(u[0], e)
        for e in self.wholelatticeNodes:
            Functions.addPredsToClearanceNode(e, self.wholelatticeNodes)
            Functions.addSuccesToClearanceNode(e, self.wholelatticeNodes)
        self.latticeNodes.sort(key =lambda x: x.flgClr, reverse=True)  
        self.scene.wholelatticeNodes = self.wholelatticeNodes      
                
    def updateClrNodeColor(self):
        for n in self.scene.main.generalGraphLayout.V:
            n.firstCompute = True
        for n in self.scene.main.wholeGraphDialog.wholeGraphScene.wholeV:
            n.firstCompute = True
    
    def setupSecurityHierarchyForDel(self):
        newlatticeNodes = []
        newWholeLatticeNodes = []
        #print self.scene.newcategoryCombination
        for clr in self.scene.newClearance:
            for cate in self.scene.newcategoryCombination:
                if cate == []:
                    cate1 = ['']
                else:
                    cate1 = cate
                for n in self.latticeNodes:
                    if n.clearance == clr and set(n.category) == set(cate1):
                        self.latticeNodes.remove(n)
                        newlatticeNodes.append(n)
                        if n in self.scene.items():
                            self.scene.removeItem(n)
                        if n in self.scene.main.generalGraphLayout.V:
                            self.scene.main.generalGraphLayout.V.remove(n)
                        for e in self.scene.main.generalGraphLayout.E:
                            if e.startItem == n:
                                self.scene.removeItem(e)
                                self.scene.main.generalGraphLayout.E.remove(e)
                            if e.endItem == n:
                                self.scene.removeItem(e)
                                self.scene.main.generalGraphLayout.E.remove(e)

                for n in self.wholelatticeNodes:
                    if n.clearance == clr and set(n.category) == set(cate1):
                        self.wholelatticeNodes.remove(n)
                        newWholeLatticeNodes.append(n)
                        self.scene.main.wholeGraphDialog.wholeGraphScene.deleteNode(n)
                                
        self.scene.wholelatticeNodes = self.wholelatticeNodes
        for item in self.latticeNodes:
            item.flgClr = self.getClearanceFlg(item)
            item.parent = []
            item.children = []
        for item in self.wholelatticeNodes:
            item.flgClr = self.getClearanceFlg(item)
            item.parent = []
            item.children = []
            item.rootNode = False
            item.leafNode = False
            item.groupingChildrenPath = []
        self.scene.firstNode, self.scene.lastNode = Functions.generatePredSucc(self.latticeNodes, self.latticeNodes)
        Functions.generatePredSucc(self.wholelatticeNodes, self.wholelatticeNodes)
        self.scene.main.wholeGraphDialog.wholeGraphScene.newClrCateReset = True
        self.add2Scene.getNodeLevel()
        self.updateClrNodeColor()
        self.scene.growLevelLayout.rePositionAllNodesClrCateChange()
        
    def setupSecurityHierarchy(self):
        newlatticeNodes = []
        newWholeLatticeNodes = []
        for clr in self.scene.newClearance:
            #print 'newcategoryCombination', self.scene.newcategoryCombination
            for cate in self.scene.newcategoryCombination:
                if cate == []:
                    cate1 = ['']
                else:
                    cate1 = cate
                self.latticeNode = ClearanceNode(clr, cate1, self.scene)
                Functions.getClearanceNodeNameFromClrCate(self.latticeNode, clr, cate)
                self.latticeNode.flgClr = self.getClearanceFlg(self.latticeNode)
                self.latticeNodes.append(self.latticeNode)
                newlatticeNodes.append(self.latticeNode)
                self.latticeNodes.sort(key =lambda x: x.flgClr, reverse=True)   
                self.wholelatticeNode = ClearanceNode("", [], self.scene)
                self.wholelatticeNode.name = self.latticeNode.name
                self.wholelatticeNode.clearance = self.latticeNode.clearance
                self.wholelatticeNode.category = self.latticeNode.category
                self.wholelatticeNode.flgClr = self.latticeNode.flgClr
                newWholeLatticeNodes.append(self.wholelatticeNode)
                self.wholelatticeNodes.append(self.wholelatticeNode)
        self.scene.wholelatticeNodes = self.wholelatticeNodes
        for item in self.latticeNodes:
            item.flgClr = self.getClearanceFlg(item)
            item.parent = []
            item.children = []
        for item in self.wholelatticeNodes:
            item.flgClr = self.getClearanceFlg(item)
            item.parent = []
            item.children = []
            item.rootNode = False
            item.leafNode = False
            item.groupingChildrenPath = []
            item.groupingParentPath = []
            item.groupingOriChildrenPath = []
        #self.scene.firstNode, self.scene.lastNode = Functions.generatePredSucc(self.latticeNodes, newlatticeNodes)
        self.scene.firstNode, self.scene.lastNode = Functions.generatePredSucc(self.latticeNodes, self.latticeNodes)
        Functions.generatePredSucc(self.wholelatticeNodes, newWholeLatticeNodes)
        self.scene.main.wholeGraphDialog.wholeGraphScene.newClrCateReset = True
        self.add2Scene.getNodeLevel()
        self.updateClrNodeColor()
        self.scene.growLevelLayout.rePositionAllNodesClrCateChange()
        