'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Man Wang
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
from PyQt4.QtGui import *
from PyQt4.QtCore import  *
from commonFunction import Functions

class FileNode(QGraphicsRectItem):
    
    def __init__(self, name, type, flag):
        QGraphicsRectItem.__init__(self)
        self.setRect(-15,-8,30,16)
        self.type = type
        self.name = name
        self.flag = flag
        self.children = []
        self.parents = None
        self.edgeList = []
        self.inheritFromNode = None
        self.parentName = ''
        self.pixelmapItem = QGraphicsPixmapItem(self)

    def constructSecurityInfoPic(self):
        self.securityPix = QPixmap(29, 15)
        self.image = self.securityPix.toImage()
        if self.type:
            for i in xrange(self.securityPix.width()):
                for j in xrange(self.securityPix.height()):
                    if i > 0.5*self.securityPix.width():
                        for n in self.scene().legend:
                            if n != 'No Clearance' and n.categoryNumStr == self.type.categoryNumStr:
                                self.image.setPixel(i,j, qRgb(n.color[0], n.color[1], n.color[2]))
                    else:
                        color0,color1,color2 = Functions.colorMapping(self.type.clearance, self.scene().clearances)
                        self.image.setPixel(i,j,qRgb(color0, color1, color2))
                                    
        self.securityPix = self.securityPix.fromImage(self.image)
        self.blackPix = QPixmap(29, 15)
        self.blackPix.fill(QColor(0,0,0))
        
    def paint(self, painter, option, widget=None):
        self.constructSecurityInfoPic()
        if self.type == None:
            self.pixelmapItem.setPixmap(self.blackPix)
        else:
            self.pixelmapItem.setPixmap(self.securityPix)
        self.pixelmapItem.setOffset(-14,-7.5)
        QGraphicsRectItem.paint(self, painter, option, widget)
        QGraphicsPixmapItem.paint(self.pixelmapItem, painter, option, widget)
        font = self.scene().font()
        font.setPixelSize(15)
        painter.setFont(font)

        x = int(self.rect().topLeft().x())
        y = int(self.rect().topLeft().y()-20)

        rect = painter.fontMetrics().boundingRect(self.name+'/')
        rect.moveTo(x, y)
        painter.drawText(rect, Qt.AlignCenter, self.name+'/')
            
        if self.flag == 3 or self.flag == 1:
            painter.drawArc(self.boundingRect().adjusted(-5, -5, 5, 5,), 0, 5760)
                     
            
