'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Man Wang
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
@author: mandy
'''
from PyQt4.QtCore import QThread, pyqtSignal
from ClearanceNode import ClearanceNode
from UserNode import UserNode
import math

class GeneralGraphLayoutStrategy(QThread):
    showCurrentResult = pyqtSignal()

    def __init__(self, scene):
        QThread.__init__(self)
        self.scene = scene
        self.V = []
        self.E = []
    
    def clearVE(self):
        self.V = []
        self.E = []
            
    def mapToScene(self): 
        self.viewWidth = self.scene.viewWidth
        self.viewHeight = self.scene.viewHeight
        if self.scene.main.ui.actionGeneral_Graph.isChecked():
            for item in self.scene.items():
                if isinstance(item, ClearanceNode) and item in self.V:
                    item.setPos(item.relativeX+self.viewWidth/2.0+self.scene.x, \
                                -item.relativeY+self.viewHeight/2.0+self.scene.y)
                    self.scene.main.setUserNodeAroundClrNode(item, self.scene.USERCLRDISTANCE)
            for e in self.E:
                e.updatePosition()
            
                          
                        
                        
                        
                    
                        
                        
                        
                        
                        
                        

   

            
        
        
        
