'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Man Wang
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on Oct 13, 2013

@author: mandy
'''
from PyQt4.QtGui import QApplication, QDialog
from PyQt4.QtCore import QCoreApplication, Qt
import sys
from MainWindow import MainWindow
from Ui_Greeting import Ui_Greeting
from MLSForCommandLine import MLSForCommandLine

class GreetingWindow(QDialog):
    def __init__(self):
        QDialog.__init__(self)
        self.ui = Ui_Greeting()
        self.ui.setupUi(self)
        flags = Qt.Dialog | Qt.WindowStaysOnTopHint
        self.setWindowFlags(flags)
        self.ui.pushButton.clicked.connect(self.close)
        
def main():
    app = QApplication(sys.argv)
    QCoreApplication.setApplicationName('MLSvisual')
    QCoreApplication.setApplicationVersion('1.0')
    
    QApplication.setStyle('plastique')
    app.setStyleSheet("""QToolTip {
                        background-color:white;
                        color:black;
    }""")
     
    greetWin = GreetingWindow()
    greetWin.show()
     
    mainw = MainWindow()
    mainw.show()
    exitcode = app.exec_()
    sys.exit(exitcode)
    
if __name__ == '__main__':
#     mls = MLSForCommandLine()
    main()