'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Man Wang
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on Oct 13, 2013

@author: mandy
'''
from PyQt4.QtGui import *
from PyQt4.QtCore import QRect, QString, pyqtSignal
from Ui_NewClrCateDlg import Ui_NewClrCateDlg
from commonFunction import Functions
try:
    _fromUtf8 = QString.fromUtf8
except AttributeError:
    _fromUtf8 = lambda s: s
    
class NewClrCateDialog(QDialog):
    updateSpec = pyqtSignal(QString,int, int)
    def __init__(self, scene):
        QDialog.__init__(self, scene.main)
        self.scene = scene
        self.ui = Ui_NewClrCateDlg()      
        self.ui.setupUi(self)
        self.setLayout(self.ui.verticalLayout)
        self.isClr = True
        self.isClrDel = True

    def eraseVerticalLayout(self):
        for i in range(self.ui.verticalLayout.count()): self.ui.verticalLayout.itemAt(i).widget().close()
    
    def clrInsertPos(self):
        for i in xrange(len(self.radioBtnList)):
            if self.radioBtnList[i].isChecked():
                return i
        return 0
            
    def confirm(self):
        name = self.ui.leName.text()
        if len(name)>0: 
            if Functions.nameOnlyContainLetters(name):
                if self.isClr:
                    if Functions.checkNameDuplication(name, self.scene.clearances):
                        QMessageBox.warning(self, '', 'Duplicated name. Please input another name!', buttons = QMessageBox.Close)
                    else:
                        step = self.clrInsertPos()
                        self.scene.main.createClrCateInfo(name, 1, step)
                        self.close()
                else:
                    if Functions.checkNameDuplication(name, self.scene.categories):
                        QMessageBox.warning(self, '', 'Duplicated name. Please input another name', buttons = QMessageBox.Close)
                    else:
                        step = -1
                        self.scene.main.createClrCateInfo(name, 0, step)
                        self.close()
            else:
                QMessageBox.warning(self, '', 'Please input a name that only contains letters and numbers', buttons = QMessageBox.Close)
        else:
            QMessageBox.warning(self, '', 'Please input a name', buttons = QMessageBox.Close)
    
    def deleteConfirm(self):
        if self.isClrDel:
            ret = QMessageBox.warning(self, '', 'Are you sure to delete selected clearance?', buttons = QMessageBox.Yes| QMessageBox.No, defaultButton=QMessageBox.No)
        else:
            ret = QMessageBox.warning(self, '', 'Are you sure to delete selected category?', buttons = QMessageBox.Yes| QMessageBox.No, defaultButton=QMessageBox.No)
        if ret == QMessageBox.Yes:
            index = self.clrInsertPos()
            self.scene.main.delClrCateInfo(self.isClrDel, index)
            self.close()
    
    def insertNewClr(self):
        self.isClr = True
        self.radioBtnList = []
        self.eraseVerticalLayout()
        self.ui.labNewClr = QLabel(self.ui.verticalLayoutWidget)
        self.ui.labNewClr.setGeometry(QRect(10,10,130,20))
        self.ui.labNewClr.setObjectName(_fromUtf8("labNewClr"))
        self.ui.verticalLayout.addWidget(self.ui.labNewClr)
        self.ui.leName = QLineEdit(self.ui.verticalLayoutWidget)
        self.ui.leName.setGeometry(QRect(10, 40, 130, 20))
        self.ui.leName.setObjectName(_fromUtf8("lineEditName"))
        self.ui.verticalLayout.addWidget(self.ui.leName)
        numClr = len(self.scene.clearances)
        height = 100+40*(numClr+1)
        self.setFixedHeight(height)
        self.ui.labNewClr.setText('New Clearance:')
        if numClr>0:
            self.ui.labInsert = QLabel('Insert at:', self.ui.verticalLayoutWidget)
            self.ui.labInsert.setGeometry(QRect(10, 70, 130, 20))
            self.ui.labInsert.setObjectName(_fromUtf8("labInsertafter"))
            self.ui.verticalLayout.addWidget(self.ui.labInsert)
            for i in xrange(numClr+1):
                if i ==0:
                    radiobutton = QRadioButton(QString('Lower than '+self.scene.clearances[i]), self)
                    radiobutton.setChecked(True)
                else:
                    radiobutton = QRadioButton(QString('Higher than '+self.scene.clearances[i-1]), self)
                self.ui.verticalLayout.addWidget(radiobutton)
                radiobutton.show()
                self.radioBtnList.append(radiobutton)
        self.ui.btnOK = QPushButton('OK', self.ui.verticalLayoutWidget)
        self.ui.btnOK.setDefault(True)
        self.ui.btnOK.setGeometry(QRect(10, 70, 130, 20))
        self.ui.btnOK.setObjectName(_fromUtf8("btnOK"))
        self.ui.verticalLayout.addWidget(self.ui.btnOK)
        self.ui.btnOK.clicked.connect(self.confirm)
        self.show()
        
    def insertNewCate(self):
        self.isClr = False
        self.radioBtnList = []
        self.eraseVerticalLayout()
        self.ui.labNewClr = QLabel(self.ui.verticalLayoutWidget)
        self.ui.labNewClr.setGeometry(QRect(10,10,130,20))
        self.ui.labNewClr.setObjectName(_fromUtf8("labNewClr"))
        self.ui.verticalLayout.addWidget(self.ui.labNewClr)
        self.ui.leName = QLineEdit(self.ui.verticalLayoutWidget)
        self.ui.leName.setGeometry(QRect(10, 40, 130, 20))
        self.ui.leName.setObjectName(_fromUtf8("lineEditName"))
        self.ui.verticalLayout.addWidget(self.ui.leName)
        
        self.setFixedHeight(120)
        self.ui.labNewClr.setText('New Category:')
        self.ui.btnOK = QPushButton('OK', self.ui.verticalLayoutWidget)
        self.ui.btnOK.setDefault(True)
        self.ui.btnOK.setGeometry(QRect(10, 70, 130, 20))
        self.ui.btnOK.setObjectName(_fromUtf8("btnOK"))
        self.ui.verticalLayout.addWidget(self.ui.btnOK)
        self.ui.btnOK.clicked.connect(self.confirm)
        self.show()
        
    def delSelectedClr(self):
        self.isClrDel = True
        numClr = len(self.scene.clearances)
        if numClr > 0:
            self.radioBtnList = []
            self.eraseVerticalLayout()
            self.ui.labNewClr = QLabel(self.ui.verticalLayoutWidget)
            self.ui.labNewClr.setGeometry(QRect(10,10,130,20))
            self.ui.labNewClr.setObjectName(_fromUtf8("labNewClr"))
            self.ui.verticalLayout.addWidget(self.ui.labNewClr)
            
            height = 40*(numClr+1)
            self.setFixedHeight(height)
            self.ui.labNewClr.setText('Delete Clearance:')
            for i in xrange(numClr):
                radiobutton = QRadioButton(QString(self.scene.clearances[i]), self)
                if i==0:
                    radiobutton.setChecked(True)
                self.ui.verticalLayout.addWidget(radiobutton)
                radiobutton.show()
                self.radioBtnList.append(radiobutton)
            self.ui.btnOK = QPushButton('OK', self.ui.verticalLayoutWidget)
            self.ui.btnOK.setDefault(True)
            self.ui.btnOK.setGeometry(QRect(10, 70, 130, 20))
            self.ui.btnOK.setObjectName(_fromUtf8("btnOK"))
            self.ui.verticalLayout.addWidget(self.ui.btnOK)
            self.ui.btnOK.clicked.connect(self.deleteConfirm)
            self.show()
        
    def delSelectedCate(self):
        self.isClrDel = False
        numCate = len(self.scene.categories)
        if numCate>0:
            self.radioBtnList = []
            self.eraseVerticalLayout()
            self.ui.labNewClr = QLabel(self.ui.verticalLayoutWidget)
            self.ui.labNewClr.setGeometry(QRect(10,10,130,20))
            self.ui.labNewClr.setObjectName(_fromUtf8("labNewClr"))
            self.ui.verticalLayout.addWidget(self.ui.labNewClr)
            self.setFixedHeight(40*numCate+40)
            self.ui.labNewClr.setText('Delete Category:')
            for i in xrange(numCate):
                radiobutton = QRadioButton(QString(self.scene.categories[i]), self)
                if i==0:
                    radiobutton.setChecked(True)
                self.ui.verticalLayout.addWidget(radiobutton)
                radiobutton.show()
                self.radioBtnList.append(radiobutton)
            self.ui.btnOK = QPushButton('OK', self.ui.verticalLayoutWidget)
            self.ui.btnOK.setDefault(True)
            self.ui.btnOK.setGeometry(QRect(10, 70, 130, 20))
            self.ui.btnOK.setObjectName(_fromUtf8("btnOK"))
            self.ui.verticalLayout.addWidget(self.ui.btnOK)
            self.ui.btnOK.clicked.connect(self.deleteConfirm)
            self.show()
    