'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Man Wang
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on Nov 15, 2013

@author: mandy
'''
from PyQt4.QtGui import *
from PyQt4.QtCore import *

class QCustomLineEdit(QLineEdit):

    def __init__(self, parent):
        QLineEdit.__init__(self,parent)
        self.textChanged.connect(self.onTextChanged)
        self.connect(self, SIGNAL("textChanged()"),lambda text: self.onTextChanged(text))
        self.connect(self, SIGNAL("cursorPositionChanged()"),lambda x,y: self.onCursorPositionChanged(x,y))

        self.setEchoMode(QLineEdit.Normal)
        self.echoMode = self.echoMode()            #// Member variable to store original echo mode..
        self.placeHolderText = "clearance,(1,2)"     #// Member variable..
        self.isPlaceHolderActive = True       #// Member varible..
        #self.setPlaceholderText("clearance,(1,2)")
        #self.setText("clearance,(1,2)")
        self.setStyleSheet("QCustomLineEdit{color: gray;}")
        self.setCursorPosition(0)
    
    def focusInEvent(self, e):
        if self.text()==self.placeHolderText:
            self.setText("")
            self.setCursorPosition(0)
        return QLineEdit.focusInEvent(self, e)
        
    
#    def focusOutEvent(self, e):
#        self.setText(self.placeHolderText)
#        self.setStyleSheet("QCustomLineEdit{color: gray;}")
#        self.setCursorPosition(0)
#        self.isPlaceHolderActive = True
#        return QLineEdit.focusOutEvent(self, e)
    
    def keyPressEvent(self, e):
        if  self.isPlaceHolderActive:
            if e.key() == Qt.Key_Delete or e.key() == Qt.Key_Backspace:
                e.accept()
            else:
                QLineEdit.keyPressEvent(self, e)
            return
        QLineEdit.keyPressEvent(self,e)
        
    def onCursorPositionChanged(self, oldPos, newPos):
        if self.isPlaceHolderActive:
            if newPos != 0:
                self.setCursorPosition(0)
                
    def onTextChanged(self, text):
        if self.isPlaceHolderActive:
            if text.compare(self.placeHolderText) != 0:
                self.isPlaceHolderActive = False
    
                temp = QString(text)
                temp = temp[0: text.lastIndexOf(self.placeHolderText)]
    
                self.setStyleSheet("QCustomLineEdit{color: black;}")
                self.setEchoMode(self.echoMode)
                self.setText(temp)
            else:
                self.setEchoMode(QLineEdit.Normal)
                self.setText(self.placeHolderText)
                self.setStyleSheet("QCustomLineEdit{color: gray;}")
                self.setCursorPosition(0)
        else:
            if(text.isEmpty()):
                self.isPlaceHolderActive = True
                self.setStyleSheet("QCustomLineEdit{color: gray;}")
                self.setEchoMode(QLineEdit.Normal)
                self.setText(self.placeHolderText)