'''
Created on Jan 24, 2015

@author: manwang
'''
from PyQt4 import QtCore, QtGui
import re
from UserNode import UserNode
from EdgeItem import EdgeItem

try:
    _fromUtf8 = QtCore.QString.fromUtf8
except AttributeError:
    _fromUtf8 = lambda s: s

class Ui_ToolBox(object):
    NUM_GROUPBOX = 3
    '''ids for tabs'''
    MODIFY_TAB = 0
    ADD_TAB = 1
    DELETE_TAB = 2
    '''none item in combobox'''
    NONE_ITEM = 'None'
    
    def setupUi(self, Form, main):
        Form.setObjectName(_fromUtf8("Form"))
        Form.resize(214, 618)
        Form.setAutoFillBackground(True)
        self.tabId = 0
        self.main = main
        self.clrList = []
        self.userList = []
        self.cateList = []
        self.gridWidget = QtGui.QWidget()
        grid = QtGui.QGridLayout(self.gridWidget)
        grid.addWidget(self.createEditPolicy(), 0, 0)
        #grid.addWidget(self.createItemPanel(), 1, 0)
        self.gridWidget.setLayout(grid)
    
    '''generic UI operations'''
    def isNameEmpty(self, name):
        p = re.compile('^(\s)*$')
        if p.match(name):
            return True
        else:
            return False
        
    def addItemsToComboBox(self, itemlist, comboBox):
        for i in itemlist:
            comboBox.addItem(i)
            
    '''Initiation'''     
    def initToolBoxUISelection(self):
        self.clrModifyRBtn.setChecked(True)
        self.clrAddRBtn.setChecked(True)
        self.clrDeleteRBtn.setChecked(True)
        self.enableClearancePanel()
    
    def tabCurrentIdChanged(self, currentid):
        self.tabId = currentid
        #self.getContentForComboBox()
        
    '''UI creation'''
    def createEditPolicy(self):
        groupbox = QtGui.QGroupBox('Policy Editing')
        vbox = QtGui.QVBoxLayout()
        self.itemTabWidget = QtGui.QTabWidget()
        self.itemTabWidget.addTab(self.createModifyItemExclusiveGroup(), "Modify")
        self.itemTabWidget.addTab(self.createAddItemExclusiveGroup(), "Add")
        self.itemTabWidget.addTab(self.createDeleteItemExclusiveGroup(), "Delete")
        self.itemTabWidget.currentChanged.connect(self.tabCurrentIdChanged)
        vbox.addWidget(self.itemTabWidget)
        groupbox.setLayout(vbox)
        return groupbox
    
    def createModifyItemExclusiveGroup(self):
        groupBox = QtGui.QGroupBox('')
        self.roleModifyRBtn = QtGui.QRadioButton('&Clearance')
        self.dirModifyRBtn = QtGui.QRadioButton('&Category')
        self.userModifyRBtn = QtGui.QRadioButton('&User')
        self.roleModifyRBtn.clicked.connect(self.enableClearancePanel)
        self.dirModifyRBtn.clicked.connect(self.enableCatePanel)
        self.userModifyRBtn.clicked.connect(self.enableUserPanel)
        self.roleModifyRBtn.setChecked(True)
        vbox = QtGui.QVBoxLayout()
        hbox = QtGui.QHBoxLayout()
        hbox.addWidget(self.roleModifyRBtn)
        hbox.addWidget(self.dirModifyRBtn)
        hbox.addWidget(self.userModifyRBtn)
        hbox.addStretch(1)
        vbox.addItem(hbox)
        vbox.addWidget(self.createPanelModifyItem())
        vbox.addStretch(1)
        groupBox.setLayout(vbox)
        return groupBox
    
    def createAddItemExclusiveGroup(self):
        addItemGroupBox = QtGui.QGroupBox('')
        self.clrAddRBtn = QtGui.QRadioButton('&Clearance')
        self.cateAddRBtn = QtGui.QRadioButton('&Category')
        self.userAddRBtn = QtGui.QRadioButton('&User')
        self.clrAddRBtn.clicked.connect(self.enableClearancePanel)
        self.cateAddRBtn.clicked.connect(self.enableCatePanel)
        self.userAddRBtn.clicked.connect(self.enableUserPanel)
        self.clrAddRBtn.setChecked(True)
        vbox = QtGui.QVBoxLayout()
        hbox = QtGui.QHBoxLayout()
        hbox.addWidget(self.clrAddRBtn)
        hbox.addWidget(self.cateAddRBtn)
        hbox.addWidget(self.userAddRBtn)
        hbox.addStretch(1)
        vbox.addItem(hbox)
        vbox.addWidget(self.createPanelAddItem())
        vbox.addStretch(1)
        addItemGroupBox.setLayout(vbox)
        return addItemGroupBox
    
    def createDeleteItemExclusiveGroup(self):
        self.deleteItemGroupBox = QtGui.QGroupBox('')
        self.clrDeleteRBtn = QtGui.QRadioButton('&Clearance')
        self.cateDeleteRBtn = QtGui.QRadioButton('&Category')
        self.userDeleteRBtn = QtGui.QRadioButton('&User')
        self.clrDeleteRBtn.clicked.connect(self.enableClearancePanel)
        self.cateDeleteRBtn.clicked.connect(self.enableCatePanel)
        self.userDeleteRBtn.clicked.connect(self.enableUserPanel)
        self.clrDeleteRBtn.setChecked(True)
        vbox = QtGui.QVBoxLayout()
        hbox = QtGui.QHBoxLayout()
        hbox.addWidget(self.clrDeleteRBtn)
        hbox.addWidget(self.cateDeleteRBtn)
        hbox.addWidget(self.userDeleteRBtn)
        hbox.addStretch(1)
        vbox.addItem(hbox)
        vbox.addWidget(self.createPanelDeleteItem())
        vbox.addStretch(1)
        self.deleteItemGroupBox.setLayout(vbox)
        return self.deleteItemGroupBox
    
    def createPanelModifyItem(self):
        widget = QtGui.QWidget()
        vbox = QtGui.QVBoxLayout()
        vbox.addWidget(self.createConnectionPanelModifyItem())
#         vbox.addWidget(self.createHierarchyPanelModifyItem())
        widget.setLayout(vbox)
        self.enableClearancePanel()
        return widget
    
    def createPanelAddItem(self):
        addItemPanelVbox = QtGui.QVBoxLayout()
        addItemPanelGroupBox = QtGui.QGroupBox('')
#         self.addItemNameLabel = QtGui.QLabel()
#         self.addItemNameLabel.setText('Clearance')
        self.addItemNameInputLineEdit = QtGui.QLineEdit(addItemPanelGroupBox)
        self.addBtn = QtGui.QPushButton('Add')
        self.addBtn.clicked.connect(self.addItem)
#         addItemPanelVbox.addWidget(self.addItemNameLabel)
        addItemPanelVbox.addWidget(self.addItemNameInputLineEdit)
        addItemPanelVbox.addWidget(self.addBtn)
        self.enableClearancePanel()
        addItemPanelGroupBox.setLayout(addItemPanelVbox)
        return addItemPanelGroupBox
        
    def enableClearancePanel(self):
        if self.tabId == self.ADD_TAB:
            #self.addItemNameLabel.setText('Clearance To Add')
            self.addItemNameInputLineEdit.clear()
#         elif self.tabId == self.DELETE_TAB:
#             self.deleteItemNameLabel.setText('Clearance To Delete')
        elif self.tabId == self.MODIFY_TAB:
            return
#             self.modifyGroupbox1.setVisible(False)
#             self.modifyConnectionPanelGroupBox.setVisible(False)
#             self.modifyBtn_addRoleParent.setChecked(True)
#             self.modifyBtn_addRoleChildren.setChecked(True)
#             self.modifyItemPanelGroupBox.setVisible(True)
        #self.getContentForComboBox()
        
    def enableUserPanel(self):
        if self.tabId == self.MODIFY_TAB:
            return
#             self.modifyItemNameLabel.setText('User Name')
#             self.modifyGroupbox1.setTitle('Roles')
#             self.modifyRadioBtn_add1.setChecked(True)
#             self.modifyGroupbox1.setVisible(True)
#             self.permsGroupBox.setVisible(False)
#             self.modifyConnectionPanelGroupBox.setVisible(True)
#             self.modifyItemPanelGroupBox.setVisible(False)
        elif self.tabId == self.ADD_TAB:
            #self.addItemNameLabel.setText('User To Add')
            self.addItemNameInputLineEdit.clear()
#         elif self.tabId == self.DELETE_TAB:
#             self.deleteItemNameLabel.setText('User To Delete')
        #self.getContentForComboBox()
    
    def enableCatePanel(self):
        if self.tabId == self.MODIFY_TAB:
            return
#             self.modifyItemNameLabel.setText('Category')
#             self.modifyGroupbox1.setTitle('Clearances')
#             self.modifyGroupbox1.setVisible(True)
#             self.modifyRadioBtn_add1.setChecked(True)
#             self.permsGroupBox.setVisible(True)
#             self.modifyConnectionPanelGroupBox.setVisible(True)
#             self.modifyItemPanelGroupBox.setVisible(False)
        elif self.tabId == self.ADD_TAB:
            #self.addItemNameLabel.setText('Category To Add')
            self.addItemNameInputLineEdit.clear()
#         elif self.tabId == self.DELETE_TAB:
#             self.deleteItemNameLabel.setText('Category To Delete')
        #self.getContentForComboBox()
        
#     def enableCatePanel(self):
#         if self.tabId == self.MODIFY_TAB:
#             self.modifyItemNameLabel.setText('Object Name')
#             self.modifyGroupbox1.setTitle('Roles')
#             self.modifyGroupbox1.setVisible(True)
#             self.modifyRadioBtn_add1.setChecked(True)
#             self.permsGroupBox.setVisible(True)
#             self.modifyConnectionPanelGroupBox.setVisible(True)
#             self.modifyItemPanelGroupBox.setVisible(False)
#         elif self.tabId == self.ADD_TAB:
#             #self.addItemNameLabel.setText('Object Name')
#             self.addItemNameInputLineEdit.clear()
#         elif self.tabId == self.DELETE_TAB:
#             self.deleteItemNameLabel.setText('Object Name')
#         self.getContentForComboBox()
        
    def lineEditInputEmptyWarning(self):
        warningText = 'Please input a '
        if self.clrAddRBtn.isChecked():
            warningText += 'clearance!'
        elif self.cateAddRBtn.isChecked():
            warningText += 'category!'
        elif self.userAddRBtn.isChecked():
            warningText += 'user name!'
        QtGui.QMessageBox.critical(self.main, 'Error', warningText)
        
    def addItem(self):
        text = str(self.addItemNameInputLineEdit.text())
        if self.isNameEmpty(text):
            self.lineEditInputEmptyWarning()
#         else:
#             if self.clrAddRBtn.isChecked():
#                 self.main.policyManager.addRoleToPolicy(text)
#             elif self.dirAddRBtn.isChecked():
#                 self.main.policyManager.addDirToPolicy(text)
#             elif self.userAddRBtn.isChecked():
#                 self.main.policyManager.addUserToPolicy(text)
#         self.getContentForComboBox()
#         self.main.specDialog.getSpecFromVisualization()
        self.addItemNameInputLineEdit.clear()

    def createPanelDeleteItem(self):
        deleteItemPanelVbox = QtGui.QVBoxLayout()
        deleteItemPanelGroupBox = QtGui.QGroupBox('')
#         self.deleteItemNameLabel = QtGui.QLabel()
#         self.deleteItemNameLabel.setText('Clearance')
        self.relatedNameLabel_delete1 = QtGui.QLabel()
        self.relatedComboBox_delete1 = QtGui.QComboBox()
        self.deleteBtn = QtGui.QPushButton('Delete')
        self.deleteBtn.clicked.connect(self.deleteItem)
#         deleteItemPanelVbox.addWidget(self.deleteItemNameLabel)
        deleteItemPanelVbox.addWidget(self.relatedComboBox_delete1)
        deleteItemPanelVbox.addWidget(self.deleteBtn)
        deleteItemPanelGroupBox.setLayout(deleteItemPanelVbox)
        self.enableClearancePanel()
        return deleteItemPanelGroupBox
    
    def deleteItem(self):
        itemName = str(self.relatedComboBox_delete1.currentText())
#         if self.clrDeleteRBtn.isChecked():
#             self.main.policyManager.deleteRoleInPolicy(itemName)
#         elif self.cateDeleteRBtn.isChecked():
#             self.main.policyManager.deleteDirInPolicy(itemName)
#         elif self.userDeleteRBtn.isChecked():
#             self.main.policyManager.deleteUserInPolicy(itemName)
#         self.getContentForComboBox()
#         self.main.specDialog.getSpecFromVisualization()

    def createConnectionPanelModifyItem(self):
        modifyItemPanelVbox = QtGui.QVBoxLayout()
        modifyItemPanelGroupBox = QtGui.QGroupBox('Assignments')
        self.modifyItemNameLabel = QtGui.QLabel()
        self.modifyItemNameComboBox = QtGui.QComboBox()
        self.modifyGroupbox1 = QtGui.QGroupBox('Users')
        vbox1 = QtGui.QVBoxLayout()
        self.relatedComboBox_modify1 = QtGui.QComboBox()
        hboxWidget1 = QtGui.QWidget(self.modifyGroupbox1)
        hbox1 = QtGui.QHBoxLayout()
        self.modifyRadioBtn_add1 = QtGui.QRadioButton('Add')
        self.modifyRadioBtn_delete1 = QtGui.QRadioButton('Delete')
        self.modifyConfirmBtn1 = QtGui.QPushButton('OK')
#         self.modifyPermsLineEdit0 = QtGui.QLineEdit()
#         self.modifyPermsCBox_recursive = QtGui.QCheckBox('Recursive')
#         self.permsGroupBox = QtGui.QGroupBox('Permissions')
#         permsVLayout = QtGui.QVBoxLayout()
#         self.modifyPermsCBox_read = QtGui.QCheckBox('Read')
#         self.modifyPermsCBox_write = QtGui.QCheckBox('Write')
#         self.modifyPermsCBox_exe = QtGui.QCheckBox('Execute')
#         permsVLayout.addWidget(self.modifyPermsCBox_recursive)
#         line = QtGui.QFrame(self.permsGroupBox)
#         line.setFrameShape(QtGui.QFrame.HLine)
#         line.setFrameShadow(QtGui.QFrame.Sunken)
#         permsVLayout.addWidget(line)
#         permsVLayout.addWidget(self.modifyPermsCBox_read)
#         permsVLayout.addWidget(self.modifyPermsCBox_write)
#         permsVLayout.addWidget(self.modifyPermsCBox_exe)
#         self.permsGroupBox.setLayout(permsVLayout)
        self.modifyGroupbox2 = QtGui.QGroupBox('Object')
        vbox2 = QtGui.QVBoxLayout()
        self.relatedComboBox_modify2 = QtGui.QComboBox()
        hboxWidget2 = QtGui.QWidget(self.modifyGroupbox2)
        hbox2 = QtGui.QHBoxLayout()
        self.modifyRadioBtn_add2 = QtGui.QRadioButton('Add')
        self.modifyRadioBtn_delete2 = QtGui.QRadioButton('Delete')
        self.modifyConfirmBtn2 = QtGui.QPushButton('OK')
        hbox2.addWidget(self.modifyRadioBtn_add2)
        hbox2.addWidget(self.modifyRadioBtn_delete2)
        hboxWidget2.setLayout(hbox2)
        hbox2.setMargin(0)
        vbox2.addWidget(hboxWidget2)
        vbox2.addWidget(self.relatedComboBox_modify2)
#         vbox1.addWidget(self.permsGroupBox)
        vbox1.addWidget(self.modifyConfirmBtn1)
        self.modifyGroupbox1.setLayout(vbox1)
        vbox2.addWidget(self.modifyConfirmBtn2)
        self.modifyGroupbox2.setLayout(vbox2)
#         self.modifyItemNameComboBox.currentIndexChanged.connect(self.getContentForModifyItem)
#         self.relatedComboBox_modify1.currentIndexChanged.connect(self.getContentForPermsComboBox0)
#         self.modifyRadioBtn_add1.clicked.connect(self.getContentForAddDeleteComboBox)
#         self.modifyRadioBtn_delete1.clicked.connect(self.getContentForAddDeleteComboBox)
#         self.modifyConfirmBtn1.clicked.connect(self.modifyItem1)
        modifyItemPanelVbox.addWidget(self.modifyItemNameLabel)
        modifyItemPanelVbox.addWidget(self.modifyItemNameComboBox)
        modifyItemPanelVbox.addWidget(self.modifyGroupbox1)
        modifyItemPanelVbox.addWidget(self.modifyGroupbox2)
        modifyItemPanelGroupBox.setLayout(modifyItemPanelVbox)
        self.modifyConnectionPanelGroupBox = modifyItemPanelGroupBox
        return modifyItemPanelGroupBox