'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Man Wang
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''

from PyQt4.QtGui import QGraphicsItem, QGraphicsPixmapItem, QBrush, QPen, QColor, QFontMetrics, QPixmap
from PyQt4.QtCore import Qt, QRectF, QObject, QSize


class UserNode(QGraphicsPixmapItem):
    def __init__(self, name, clrNode, scene = None):
        pixmap = QPixmap()
        pixmap.load("./icons/user.png")
        pixmap = pixmap.scaled(QSize(scene.USERNODESIZE,scene.USERNODESIZE))
        QGraphicsPixmapItem.__init__(self, pixmap)
        self.setFlag(QGraphicsItem.ItemIsMovable, True)
        self.setFlag(QGraphicsItem.ItemIsSelectable, True)
        self.setFlag(QGraphicsItem.ItemSendsGeometryChanges, True)
        self.scene = scene
        self.clrNode = clrNode
        self.name = name
        self.clearance = ''
        self.flgClr = -1
        self.category = []
        self.relatedClearanceNodes = []
        self.setVisible(False)
        
    def paint(self, painter, option, widget=None):
        pen = QPen(QColor(0, 0, 0))
        pen.setWidth(1.0)
        painter.setPen(pen)
        rect = painter.fontMetrics().boundingRect(self.name)
        x = int(rect.topLeft().x())
        y = int(rect.bottomRight().y()+1.5*rect.height())
        rect = QRectF(x, y, rect.width(), 1.5*rect.height())
        QGraphicsPixmapItem.paint(self, painter, option, widget)
        painter.drawText(rect, Qt.AlignLeft, self.name)
                
    def itemChange(self, change, value):
#         if change == QGraphicsItem.ItemPositionChange:
# #             for edge in self.edgeList:
# #                 edge.updatePosition()
        return value 
        
    

        