'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Man Wang
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''

from PyQt4.QtGui import QGraphicsItem, QGraphicsEllipseItem, QBrush, QPen, QColor, QFontMetrics
from PyQt4.QtCore import Qt, QRectF, QObject


class UserNode(QGraphicsEllipseItem, QObject):

    def __init__(self):
        QObject.__init__(self)
        QGraphicsEllipseItem.__init__(self, QRectF(-5,-5,10,10))
        self.setFlag(QGraphicsItem.ItemIsMovable, True)
        self.setFlag(QGraphicsItem.ItemIsSelectable, True)
        self.setFlag(QGraphicsItem.ItemSendsGeometryChanges, True)
        brush = QBrush(QColor(0, 0, 255))
        self.setBrush(brush)
        #self.name = []
        self.edgeList = []
        self.clearance = ''
        self.flgClr = -1
        self.category = []
        self.users = []
        self.relatedClearanceNodes = []
        self.highlighted = False
        self.highlightColor = QColor(255, 0, 0)
        self.setVisible(False)
    '''    
    def __setattr__(self, name, value):
        self.__dict__[name] = value
        if name == 'name':
            #object.__setattr__(self, name, value)
            width = QFontMetrics(self.scene().font()).boundingRect(name).width()
            if width > self.boundingRect().width():
                self.setToolTip(name)
    '''
        
    def paint(self, painter, option, widget=None):
        '''
        if self.initialDomain:
            pen = QPen(QColor(255, 53, 0))
            pen.setWidth(2.0)
            self.setPen(pen)
        else:
        '''
        name = ''
        for i in xrange(0, len(self.users)):
            name += self.users[i]
            if i<len(self.users)-1:
                name+=','
        #for e in self.category:   
        pen = QPen(QColor(0, 0, 0))
        pen.setWidth(1.0)
        self.setPen(pen)
        rect = painter.fontMetrics().boundingRect(name)
        x = int(self.rect().topLeft().x())
        y = int(self.rect().topLeft().y()-20)
        rect.moveTo(x, y)
        QGraphicsEllipseItem.paint(self, painter, option, widget)
        painter.drawText(rect, Qt.AlignLeft, name)
        '''
        if self.highlighted:
            painter.save()
            painter.setPen(QPen(QBrush(self.highlightColor), 2.0))
            painter.setBrush(Qt.NoBrush)
            painter.drawRect(self.rect().adjusted(-5, -5, 5, 5))
            painter.restore()
        '''
                
    def itemChange(self, change, value):
        if change == QGraphicsItem.ItemPositionChange:
            for edge in self.edgeList:
                edge.updatePosition()
        return value 
        
    

        