'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Man Wang
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on 2013-02-07

@author: mandy
'''
from PyQt4.QtGui import QDialog, QSizePolicy
from PyQt4.QtCore import Qt, QRectF
from Ui_WholeGraphDialog import Ui_Dialog
from WholeGraphScene import WholeGraphScene

class WholeGraphDialog(QDialog):
    def __init__(self, scene):
        QDialog.__init__(self)
        self.scene = scene
        self.ui = Ui_Dialog()
        self.ui.setupUi(self)
        self.wholeGraphScene = WholeGraphScene(self.scene.main, self.scene)
        self.ui.wholeGraphView.setScene(self.wholeGraphScene)
        self.wholeGraphScene.setSceneRect(QRectF(0, 0, 400, 350))
        
        self.setLayout(self.ui.verticalLayout)
        flags = Qt.Dialog | Qt.WindowStaysOnTopHint
        self.setWindowFlags(flags)
        self.ui.initialPushButton.clicked.connect(self.initialWholeGraph)
        self.ui.closePushButton.clicked.connect(self.hide)
        
    def initialWholeGraph(self): 
#        if self.clearances != self.scene.clearances or self.categories != self.scene.categories:
#            self.wholeGraphScene.firstTime = True
        if self.wholeGraphScene.firstTime or self.wholeGraphScene.newClrCateReset:
            self.wholeGraphScene.searchWholePath()
        else:
            self.wholeGraphScene.restoreInitialGraph()
        
    def resizeEvent(self, evt):
        self.wholeGraphScene.resizeEvent(evt)
        return