# $ANTLR 3.1.3 Mar 18, 2009 10:09:25 AccessControl.g 2013-02-06 18:11:31

import sys
import antlr3
from antlr3 import *
from antlr3.compat import set, frozenset
         
from dtel.DTELSpecification import DTELSpecification
from dtel.TypeDeclaration import TypeDeclaration
from dtel.TypeAssignment import TypeAssignment
from dtel.EntryPointAttribute import EntryPointAttribute
from dtel.Domain import Domain
from dtel.FilePermissionSet import FilePermissionSet
from dtel.PermissionAttribute import PermissionAttribute
from dtel.TransitionAttribute import TransitionAttribute

from mls.MLSSpecification import MLSSpecification
from mls.MLSAssignment import MLSAssignment
from mls.MLSUserDeclaration import MLSUserDeclaration
 
from util.DTELError import DTELError
# for convenience in actions
HIDDEN = BaseRecognizer.HIDDEN

# token types
T__29=29
T__28=28
T__27=27
T__26=26
T__25=25
T__24=24
T__23=23
T__22=22
T__21=21
T__20=20
INT=6
PATHPREFIX=5
ID=4
EOF=-1
T__9=9
T__30=30
T__19=19
WS=8
T__16=16
T__15=15
T__18=18
T__17=17
T__12=12
T__11=11
T__14=14
T__13=13
T__10=10
COMMENT=7

# token names
tokenNames = [
    "<invalid>", "<EOR>", "<DOWN>", "<UP>", 
    "ID", "PATHPREFIX", "INT", "COMMENT", "WS", "'type'", "';'", "','", 
    "'domain'", "'='", "'('", "')'", "'setauth'", "'->'", "'auto'", "'exec'", 
    "'initial_domain'", "'assign'", "'-r'", "'-s'", "'{'", "'}'", "'clearances'", 
    "':'", "'<'", "'categories'", "'users'"
]




class AccessControlParser(Parser):
    grammarFileName = "AccessControl.g"
    antlr_version = version_str_to_tuple("3.1.3 Mar 18, 2009 10:09:25")
    antlr_version_str = "3.1.3 Mar 18, 2009 10:09:25"
    tokenNames = tokenNames

    def __init__(self, input, state=None, *args, **kwargs):
        if state is None:
            state = RecognizerSharedState()

        super(AccessControlParser, self).__init__(input, state, *args, **kwargs)






                


        

              
    def  parsePermissions(self, perms,  flags,  line,  column)  :
         i = 0
         for flag in flags :
             if flag == 'r' :  perms.setReadPermission()
             elif flag == 'w': perms.setWritePermission()
             elif flag == 'x':  perms.setExecPermission()
             elif flag ==  'c': perms.setCreatePermission()
             elif flag ==  'd': perms.setDirPermission()
             else: raise DTELError("Encountered "+flag+"at line "+line+", column "+(column+i)+".\nWas expecting one of: c,r,w,x,d")
             i = i + 1



    # $ANTLR start "accessControlSpec"
    # AccessControl.g:36:1: accessControlSpec returns [spec] : (data= dtelSpec | data= mlsSpec ) ;
    def accessControlSpec(self, ):

        spec = None

        data = None


        try:
            try:
                # AccessControl.g:37:2: ( (data= dtelSpec | data= mlsSpec ) )
                # AccessControl.g:37:4: (data= dtelSpec | data= mlsSpec )
                pass 
                # AccessControl.g:37:4: (data= dtelSpec | data= mlsSpec )
                alt1 = 2
                LA1_0 = self.input.LA(1)

                if (LA1_0 == 9) :
                    alt1 = 1
                elif (LA1_0 == 26) :
                    alt1 = 2
                else:
                    nvae = NoViableAltException("", 1, 0, self.input)

                    raise nvae

                if alt1 == 1:
                    # AccessControl.g:37:5: data= dtelSpec
                    pass 
                    self._state.following.append(self.FOLLOW_dtelSpec_in_accessControlSpec56)
                    data = self.dtelSpec()

                    self._state.following.pop()


                elif alt1 == 2:
                    # AccessControl.g:38:7: data= mlsSpec
                    pass 
                    self._state.following.append(self.FOLLOW_mlsSpec_in_accessControlSpec69)
                    data = self.mlsSpec()

                    self._state.following.pop()



                #action start
                  
                spec = data
                	
                #action end




            except RecognitionException, re:
                self.reportError(re)
                self.recover(self.input, re)
        finally:

            pass
        return spec

    # $ANTLR end "accessControlSpec"


    # $ANTLR start "dtelSpec"
    # AccessControl.g:44:1: dtelSpec returns [spec] : (typeDecl= dtelType )+ (dom= dtelDomain )+ initialDomain= dtelInitial (assign= dtelAssign )+ ;
    def dtelSpec(self, ):

        spec = None

        typeDecl = None

        dom = None

        initialDomain = None

        assign = None


               
        typeAssignments = []
        domains =[]
        types = []

        try:
            try:
                # AccessControl.g:50:2: ( (typeDecl= dtelType )+ (dom= dtelDomain )+ initialDomain= dtelInitial (assign= dtelAssign )+ )
                # AccessControl.g:50:4: (typeDecl= dtelType )+ (dom= dtelDomain )+ initialDomain= dtelInitial (assign= dtelAssign )+
                pass 
                # AccessControl.g:50:4: (typeDecl= dtelType )+
                cnt2 = 0
                while True: #loop2
                    alt2 = 2
                    LA2_0 = self.input.LA(1)

                    if (LA2_0 == 9) :
                        alt2 = 1


                    if alt2 == 1:
                        # AccessControl.g:51:3: typeDecl= dtelType
                        pass 
                        self._state.following.append(self.FOLLOW_dtelType_in_dtelSpec100)
                        typeDecl = self.dtelType()

                        self._state.following.pop()
                        #action start
                           
                        types.append(typeDecl)
                        		
                        #action end


                    else:
                        if cnt2 >= 1:
                            break #loop2

                        eee = EarlyExitException(2, self.input)
                        raise eee

                    cnt2 += 1
                # AccessControl.g:56:4: (dom= dtelDomain )+
                cnt3 = 0
                while True: #loop3
                    alt3 = 2
                    LA3_0 = self.input.LA(1)

                    if (LA3_0 == 12) :
                        alt3 = 1


                    if alt3 == 1:
                        # AccessControl.g:57:5: dom= dtelDomain
                        pass 
                        self._state.following.append(self.FOLLOW_dtelDomain_in_dtelSpec126)
                        dom = self.dtelDomain()

                        self._state.following.pop()
                        #action start
                             
                        domains.append(dom)
                        	  	
                        #action end


                    else:
                        if cnt3 >= 1:
                            break #loop3

                        eee = EarlyExitException(3, self.input)
                        raise eee

                    cnt3 += 1
                self._state.following.append(self.FOLLOW_dtelInitial_in_dtelSpec147)
                initialDomain = self.dtelInitial()

                self._state.following.pop()
                # AccessControl.g:63:4: (assign= dtelAssign )+
                cnt4 = 0
                while True: #loop4
                    alt4 = 2
                    LA4_0 = self.input.LA(1)

                    if (LA4_0 == 21) :
                        alt4 = 1


                    if alt4 == 1:
                        # AccessControl.g:64:5: assign= dtelAssign
                        pass 
                        self._state.following.append(self.FOLLOW_dtelAssign_in_dtelSpec163)
                        assign = self.dtelAssign()

                        self._state.following.pop()
                        #action start
                             
                        typeAssignments.append(assign)
                        	  	
                        #action end


                    else:
                        if cnt4 >= 1:
                            break #loop4

                        eee = EarlyExitException(4, self.input)
                        raise eee

                    cnt4 += 1
                #action start
                    
                spec = DTELSpecification(types,domains,typeAssignments,initialDomain)
                	  
                #action end




            except RecognitionException, re:
                self.reportError(re)
                self.recover(self.input, re)
        finally:

            pass
        return spec

    # $ANTLR end "dtelSpec"


    # $ANTLR start "dtelType"
    # AccessControl.g:74:1: dtelType returns [dType] : 'type' typeList= idList ';' ;
    def dtelType(self, ):

        dType = None

        typeList = None


        try:
            try:
                # AccessControl.g:75:2: ( 'type' typeList= idList ';' )
                # AccessControl.g:75:4: 'type' typeList= idList ';'
                pass 
                self.match(self.input, 9, self.FOLLOW_9_in_dtelType196)
                self._state.following.append(self.FOLLOW_idList_in_dtelType202)
                typeList = self.idList()

                self._state.following.pop()
                self.match(self.input, 10, self.FOLLOW_10_in_dtelType204)
                #action start
                  
                dType = TypeDeclaration(typeList)
                	
                #action end




            except RecognitionException, re:
                self.reportError(re)
                self.recover(self.input, re)
        finally:

            pass
        return dType

    # $ANTLR end "dtelType"


    # $ANTLR start "idList"
    # AccessControl.g:81:1: idList returns [list] : id= ID ( ',' id= ID )* ;
    def idList(self, ):

        list = None

        id = None

               
        list = []

        try:
            try:
                # AccessControl.g:85:2: (id= ID ( ',' id= ID )* )
                # AccessControl.g:85:4: id= ID ( ',' id= ID )*
                pass 
                id=self.match(self.input, ID, self.FOLLOW_ID_in_idList232)
                #action start
                   
                list.append(id.text)
                		
                #action end
                # AccessControl.g:89:4: ( ',' id= ID )*
                while True: #loop5
                    alt5 = 2
                    LA5_0 = self.input.LA(1)

                    if (LA5_0 == 11) :
                        alt5 = 1


                    if alt5 == 1:
                        # AccessControl.g:89:5: ',' id= ID
                        pass 
                        self.match(self.input, 11, self.FOLLOW_11_in_idList243)
                        id=self.match(self.input, ID, self.FOLLOW_ID_in_idList249)
                        #action start
                             
                        list.append(id.text)
                        	  	
                        #action end


                    else:
                        break #loop5




            except RecognitionException, re:
                self.reportError(re)
                self.recover(self.input, re)
        finally:

            pass
        return list

    # $ANTLR end "idList"


    # $ANTLR start "dtelDomain"
    # AccessControl.g:96:1: dtelDomain returns [domain] : 'domain' domainName= ID '=' '(' paths= pathList ')' ( ',' '(' (permission= permissionAttr | transition= transitionAttr ) ')' )* ( ( ',' 'setauth' ) ( ',' '(' (permission= permissionAttr | transition= transitionAttr ) ')' )* )? ';' ;
    def dtelDomain(self, ):

        domain = None

        domainName = None
        paths = None

        permission = None

        transition = None


               
        entryPoints = []
        permissions = []
        transitions = []
        setauth = False

        try:
            try:
                # AccessControl.g:103:2: ( 'domain' domainName= ID '=' '(' paths= pathList ')' ( ',' '(' (permission= permissionAttr | transition= transitionAttr ) ')' )* ( ( ',' 'setauth' ) ( ',' '(' (permission= permissionAttr | transition= transitionAttr ) ')' )* )? ';' )
                # AccessControl.g:103:4: 'domain' domainName= ID '=' '(' paths= pathList ')' ( ',' '(' (permission= permissionAttr | transition= transitionAttr ) ')' )* ( ( ',' 'setauth' ) ( ',' '(' (permission= permissionAttr | transition= transitionAttr ) ')' )* )? ';'
                pass 
                self.match(self.input, 12, self.FOLLOW_12_in_dtelDomain282)
                domainName=self.match(self.input, ID, self.FOLLOW_ID_in_dtelDomain288)
                self.match(self.input, 13, self.FOLLOW_13_in_dtelDomain290)
                self.match(self.input, 14, self.FOLLOW_14_in_dtelDomain292)
                self._state.following.append(self.FOLLOW_pathList_in_dtelDomain298)
                paths = self.pathList()

                self._state.following.pop()
                self.match(self.input, 15, self.FOLLOW_15_in_dtelDomain300)
                #action start
                  
                for path in paths : 
                  		entryPoints.append(EntryPointAttribute(path))
                  	
                #action end
                # AccessControl.g:108:3: ( ',' '(' (permission= permissionAttr | transition= transitionAttr ) ')' )*
                while True: #loop7
                    alt7 = 2
                    LA7_0 = self.input.LA(1)

                    if (LA7_0 == 11) :
                        LA7_1 = self.input.LA(2)

                        if (LA7_1 == 14) :
                            alt7 = 1




                    if alt7 == 1:
                        # AccessControl.g:108:5: ',' '(' (permission= permissionAttr | transition= transitionAttr ) ')'
                        pass 
                        self.match(self.input, 11, self.FOLLOW_11_in_dtelDomain309)
                        self.match(self.input, 14, self.FOLLOW_14_in_dtelDomain311)
                        # AccessControl.g:108:13: (permission= permissionAttr | transition= transitionAttr )
                        alt6 = 2
                        LA6_0 = self.input.LA(1)

                        if (LA6_0 == ID) :
                            alt6 = 1
                        elif ((18 <= LA6_0 <= 19)) :
                            alt6 = 2
                        else:
                            nvae = NoViableAltException("", 6, 0, self.input)

                            raise nvae

                        if alt6 == 1:
                            # AccessControl.g:108:15: permission= permissionAttr
                            pass 
                            self._state.following.append(self.FOLLOW_permissionAttr_in_dtelDomain319)
                            permission = self.permissionAttr()

                            self._state.following.pop()
                            #action start
                                    
                            permissions.append(permission)
                            					 	
                            #action end


                        elif alt6 == 2:
                            # AccessControl.g:112:10: transition= transitionAttr
                            pass 
                            self._state.following.append(self.FOLLOW_transitionAttr_in_dtelDomain344)
                            transition = self.transitionAttr()

                            self._state.following.pop()
                            #action start
                                   
                            transitions.append(transition)
                            					 	
                            #action end



                        self.match(self.input, 15, self.FOLLOW_15_in_dtelDomain360)


                    else:
                        break #loop7
                # AccessControl.g:118:5: ( ( ',' 'setauth' ) ( ',' '(' (permission= permissionAttr | transition= transitionAttr ) ')' )* )?
                alt10 = 2
                LA10_0 = self.input.LA(1)

                if (LA10_0 == 11) :
                    alt10 = 1
                if alt10 == 1:
                    # AccessControl.g:118:7: ( ',' 'setauth' ) ( ',' '(' (permission= permissionAttr | transition= transitionAttr ) ')' )*
                    pass 
                    # AccessControl.g:118:7: ( ',' 'setauth' )
                    # AccessControl.g:118:8: ',' 'setauth'
                    pass 
                    self.match(self.input, 11, self.FOLLOW_11_in_dtelDomain374)
                    self.match(self.input, 16, self.FOLLOW_16_in_dtelDomain376)



                    #action start
                           
                    setauth = True
                      	   
                    #action end
                    # AccessControl.g:122:8: ( ',' '(' (permission= permissionAttr | transition= transitionAttr ) ')' )*
                    while True: #loop9
                        alt9 = 2
                        LA9_0 = self.input.LA(1)

                        if (LA9_0 == 11) :
                            alt9 = 1


                        if alt9 == 1:
                            # AccessControl.g:122:10: ',' '(' (permission= permissionAttr | transition= transitionAttr ) ')'
                            pass 
                            self.match(self.input, 11, self.FOLLOW_11_in_dtelDomain396)
                            self.match(self.input, 14, self.FOLLOW_14_in_dtelDomain398)
                            # AccessControl.g:122:18: (permission= permissionAttr | transition= transitionAttr )
                            alt8 = 2
                            LA8_0 = self.input.LA(1)

                            if (LA8_0 == ID) :
                                alt8 = 1
                            elif ((18 <= LA8_0 <= 19)) :
                                alt8 = 2
                            else:
                                nvae = NoViableAltException("", 8, 0, self.input)

                                raise nvae

                            if alt8 == 1:
                                # AccessControl.g:122:20: permission= permissionAttr
                                pass 
                                self._state.following.append(self.FOLLOW_permissionAttr_in_dtelDomain406)
                                permission = self.permissionAttr()

                                self._state.following.pop()
                                #action start
                                        
                                permissions.append(permission)
                                					 	
                                #action end


                            elif alt8 == 2:
                                # AccessControl.g:126:10: transition= transitionAttr
                                pass 
                                self._state.following.append(self.FOLLOW_transitionAttr_in_dtelDomain431)
                                transition = self.transitionAttr()

                                self._state.following.pop()
                                #action start
                                       
                                transitions.append(transition)
                                					 	
                                #action end



                            self.match(self.input, 15, self.FOLLOW_15_in_dtelDomain447)


                        else:
                            break #loop9



                self.match(self.input, 10, self.FOLLOW_10_in_dtelDomain457)
                #action start
                   
                domain =  Domain(domainName.text,entryPoints,permissions,transitions,setauth)
                  
                #action end




            except RecognitionException, re:
                self.reportError(re)
                self.recover(self.input, re)
        finally:

            pass
        return domain

    # $ANTLR end "dtelDomain"


    # $ANTLR start "permissionAttr"
    # AccessControl.g:137:1: permissionAttr returns [permAttr] : flags= ID '->' types= idList ;
    def permissionAttr(self, ):

        permAttr = None

        flags = None
        types = None


               
        perms = FilePermissionSet()

        try:
            try:
                # AccessControl.g:141:2: (flags= ID '->' types= idList )
                # AccessControl.g:141:4: flags= ID '->' types= idList
                pass 
                flags=self.match(self.input, ID, self.FOLLOW_ID_in_permissionAttr488)
                self.match(self.input, 17, self.FOLLOW_17_in_permissionAttr490)
                self._state.following.append(self.FOLLOW_idList_in_permissionAttr497)
                types = self.idList()

                self._state.following.pop()
                #action start
                  
                self.parsePermissions(perms,flags.text,flags.line,flags.charPositionInLine)
                permAttr = PermissionAttribute(perms,types)
                	
                #action end




            except RecognitionException, re:
                self.reportError(re)
                self.recover(self.input, re)
        finally:

            pass
        return permAttr

    # $ANTLR end "permissionAttr"


    # $ANTLR start "transitionAttr"
    # AccessControl.g:148:1: transitionAttr returns [transition] : ( 'auto' | 'exec' ) '->' domains= idList ;
    def transitionAttr(self, ):

        transition = None

        domains = None


               
        auto = False
        exe = False

        try:
            try:
                # AccessControl.g:153:2: ( ( 'auto' | 'exec' ) '->' domains= idList )
                # AccessControl.g:153:4: ( 'auto' | 'exec' ) '->' domains= idList
                pass 
                # AccessControl.g:153:4: ( 'auto' | 'exec' )
                alt11 = 2
                LA11_0 = self.input.LA(1)

                if (LA11_0 == 18) :
                    alt11 = 1
                elif (LA11_0 == 19) :
                    alt11 = 2
                else:
                    nvae = NoViableAltException("", 11, 0, self.input)

                    raise nvae

                if alt11 == 1:
                    # AccessControl.g:153:6: 'auto'
                    pass 
                    self.match(self.input, 18, self.FOLLOW_18_in_transitionAttr523)
                    #action start
                        
                    auto = True 
                    			
                    #action end


                elif alt11 == 2:
                    # AccessControl.g:157:6: 'exec'
                    pass 
                    self.match(self.input, 19, self.FOLLOW_19_in_transitionAttr535)
                    #action start
                        
                    exe = True
                    			
                    #action end



                self.match(self.input, 17, self.FOLLOW_17_in_transitionAttr546)
                self._state.following.append(self.FOLLOW_idList_in_transitionAttr553)
                domains = self.idList()

                self._state.following.pop()
                #action start
                   
                transition = TransitionAttribute(auto,exe,domains)
                		
                #action end




            except RecognitionException, re:
                self.reportError(re)
                self.recover(self.input, re)
        finally:

            pass
        return transition

    # $ANTLR end "transitionAttr"


    # $ANTLR start "dtelInitial"
    # AccessControl.g:167:1: dtelInitial returns [domain] : 'initial_domain' '=' id= ID ';' ;
    def dtelInitial(self, ):

        domain = None

        id = None

        try:
            try:
                # AccessControl.g:168:2: ( 'initial_domain' '=' id= ID ';' )
                # AccessControl.g:168:4: 'initial_domain' '=' id= ID ';'
                pass 
                self.match(self.input, 20, self.FOLLOW_20_in_dtelInitial573)
                self.match(self.input, 13, self.FOLLOW_13_in_dtelInitial575)
                id=self.match(self.input, ID, self.FOLLOW_ID_in_dtelInitial581)
                self.match(self.input, 10, self.FOLLOW_10_in_dtelInitial583)
                #action start
                  
                domain = id.text
                	
                #action end




            except RecognitionException, re:
                self.reportError(re)
                self.recover(self.input, re)
        finally:

            pass
        return domain

    # $ANTLR end "dtelInitial"


    # $ANTLR start "dtelAssign"
    # AccessControl.g:174:1: dtelAssign returns [typeAssign] : 'assign' ( '-r' )? ( '-s' )? typeName= ID paths= pathList ';' ;
    def dtelAssign(self, ):

        typeAssign = None

        typeName = None
        paths = None


               
        recursiveOpt = False
        staticOpt = False

        try:
            try:
                # AccessControl.g:179:2: ( 'assign' ( '-r' )? ( '-s' )? typeName= ID paths= pathList ';' )
                # AccessControl.g:179:4: 'assign' ( '-r' )? ( '-s' )? typeName= ID paths= pathList ';'
                pass 
                self.match(self.input, 21, self.FOLLOW_21_in_dtelAssign606)
                # AccessControl.g:180:2: ( '-r' )?
                alt12 = 2
                LA12_0 = self.input.LA(1)

                if (LA12_0 == 22) :
                    alt12 = 1
                if alt12 == 1:
                    # AccessControl.g:180:3: '-r'
                    pass 
                    self.match(self.input, 22, self.FOLLOW_22_in_dtelAssign611)
                    #action start
                       
                    recursiveOpt = True
                    		
                    #action end



                # AccessControl.g:185:2: ( '-s' )?
                alt13 = 2
                LA13_0 = self.input.LA(1)

                if (LA13_0 == 23) :
                    alt13 = 1
                if alt13 == 1:
                    # AccessControl.g:185:3: '-s'
                    pass 
                    self.match(self.input, 23, self.FOLLOW_23_in_dtelAssign624)
                    #action start
                       
                    staticOpt = True
                    		
                    #action end



                typeName=self.match(self.input, ID, self.FOLLOW_ID_in_dtelAssign638)
                self._state.following.append(self.FOLLOW_pathList_in_dtelAssign644)
                paths = self.pathList()

                self._state.following.pop()
                self.match(self.input, 10, self.FOLLOW_10_in_dtelAssign646)
                #action start
                  
                typeAssign = TypeAssignment(typeName.text,recursiveOpt,staticOpt,paths)
                	
                #action end




            except RecognitionException, re:
                self.reportError(re)
                self.recover(self.input, re)
        finally:

            pass
        return typeAssign

    # $ANTLR end "dtelAssign"


    # $ANTLR start "pathList"
    # AccessControl.g:195:1: pathList returns [list] : pathNames= path ( ',' pathNames= path )* ;
    def pathList(self, ):

        list = None

        pathNames = None


               
        list = []

        try:
            try:
                # AccessControl.g:199:2: (pathNames= path ( ',' pathNames= path )* )
                # AccessControl.g:199:4: pathNames= path ( ',' pathNames= path )*
                pass 
                self._state.following.append(self.FOLLOW_path_in_pathList675)
                pathNames = self.path()

                self._state.following.pop()
                #action start
                  
                list.extend(pathNames)
                	
                #action end
                # AccessControl.g:203:2: ( ',' pathNames= path )*
                while True: #loop14
                    alt14 = 2
                    LA14_0 = self.input.LA(1)

                    if (LA14_0 == 11) :
                        alt14 = 1


                    if alt14 == 1:
                        # AccessControl.g:203:4: ',' pathNames= path
                        pass 
                        self.match(self.input, 11, self.FOLLOW_11_in_pathList684)
                        self._state.following.append(self.FOLLOW_path_in_pathList690)
                        pathNames = self.path()

                        self._state.following.pop()
                        #action start
                          
                        list.extend(pathNames)
                        	
                        #action end


                    else:
                        break #loop14




            except RecognitionException, re:
                self.reportError(re)
                self.recover(self.input, re)
        finally:

            pass
        return list

    # $ANTLR end "pathList"


    # $ANTLR start "path"
    # AccessControl.g:210:1: path returns [paths] : prefix= PATHPREFIX ( '{' suffixes= idList '}' )? ;
    def path(self, ):
        paths = None

        prefix = None
        suffixes = None


               
        paths = []
        suffixes = []

        try:
            try:
                # AccessControl.g:215:2: (prefix= PATHPREFIX ( '{' suffixes= idList '}' )? )
                # AccessControl.g:215:4: prefix= PATHPREFIX ( '{' suffixes= idList '}' )?
                pass 
                prefix=self.match(self.input, PATHPREFIX, self.FOLLOW_PATHPREFIX_in_path722)
                # AccessControl.g:215:24: ( '{' suffixes= idList '}' )?
                alt15 = 2
                LA15_0 = self.input.LA(1)

                if (LA15_0 == 24) :
                    alt15 = 1
                if alt15 == 1:
                    # AccessControl.g:215:26: '{' suffixes= idList '}'
                    pass 
                    self.match(self.input, 24, self.FOLLOW_24_in_path726)
                    self._state.following.append(self.FOLLOW_idList_in_path732)
                    suffixes = self.idList()

                    self._state.following.pop()
                    self.match(self.input, 25, self.FOLLOW_25_in_path734)



                #action start
                  
                if len(suffixes) == 0 : paths.append(prefix.text)
                else :
                	if prefix.text[len(prefix.text)-1] == '/' :
                		for id in suffixes :
                			paths.append(prefix.text + id)
                	else :
                		raise DTELError('Encountered { at line '+prefix.line+', column '+prefix.charPositionInLine+'. Expected /')
                	
                #action end




            except RecognitionException, re:
                self.reportError(re)
                self.recover(self.input, re)
        finally:

            pass
        return paths

    # $ANTLR end "path"


    # $ANTLR start "mlsSpec"
    # AccessControl.g:227:1: mlsSpec returns [spec] : clearances= mlsClearances categories= mlsCategories assignments= mlsAssigns users= mlsUsers ;
    def mlsSpec(self, ):

        spec = None

        clearances = None

        categories = None

        assignments = None

        users = None


        try:
            try:
                # AccessControl.g:228:2: (clearances= mlsClearances categories= mlsCategories assignments= mlsAssigns users= mlsUsers )
                # AccessControl.g:228:4: clearances= mlsClearances categories= mlsCategories assignments= mlsAssigns users= mlsUsers
                pass 
                self._state.following.append(self.FOLLOW_mlsClearances_in_mlsSpec759)
                clearances = self.mlsClearances()

                self._state.following.pop()
                self._state.following.append(self.FOLLOW_mlsCategories_in_mlsSpec765)
                categories = self.mlsCategories()

                self._state.following.pop()
                self._state.following.append(self.FOLLOW_mlsAssigns_in_mlsSpec771)
                assignments = self.mlsAssigns()

                self._state.following.pop()
                self._state.following.append(self.FOLLOW_mlsUsers_in_mlsSpec777)
                users = self.mlsUsers()

                self._state.following.pop()
                #action start
                     
                spec = MLSSpecification(clearances, categories, assignments,users)
                	   
                #action end




            except RecognitionException, re:
                self.reportError(re)
                self.recover(self.input, re)
        finally:

            pass
        return spec

    # $ANTLR end "mlsSpec"


    # $ANTLR start "mlsClearances"
    # AccessControl.g:234:1: mlsClearances returns [clearanceList] : 'clearances' ':' clearance= ID ( '<' clearance= ID )* ;
    def mlsClearances(self, ):

        clearanceList = None

        clearance = None

               
        clearanceList = []

        try:
            try:
                # AccessControl.g:238:2: ( 'clearances' ':' clearance= ID ( '<' clearance= ID )* )
                # AccessControl.g:238:4: 'clearances' ':' clearance= ID ( '<' clearance= ID )*
                pass 
                self.match(self.input, 26, self.FOLLOW_26_in_mlsClearances804)
                self.match(self.input, 27, self.FOLLOW_27_in_mlsClearances806)
                clearance=self.match(self.input, ID, self.FOLLOW_ID_in_mlsClearances815)
                #action start
                     
                clearanceList.append(clearance.text)
                	   
                #action end
                # AccessControl.g:243:4: ( '<' clearance= ID )*
                while True: #loop16
                    alt16 = 2
                    LA16_0 = self.input.LA(1)

                    if (LA16_0 == 28) :
                        alt16 = 1


                    if alt16 == 1:
                        # AccessControl.g:243:5: '<' clearance= ID
                        pass 
                        self.match(self.input, 28, self.FOLLOW_28_in_mlsClearances828)
                        clearance=self.match(self.input, ID, self.FOLLOW_ID_in_mlsClearances834)
                        #action start
                             
                        clearanceList.append(clearance.text)
                        	   
                        #action end


                    else:
                        break #loop16




            except RecognitionException, re:
                self.reportError(re)
                self.recover(self.input, re)
        finally:

            pass
        return clearanceList

    # $ANTLR end "mlsClearances"


    # $ANTLR start "mlsCategories"
    # AccessControl.g:250:1: mlsCategories returns [categoryList] : 'categories' ':' categories= idList ;
    def mlsCategories(self, ):

        categoryList = None

        categories = None


        try:
            try:
                # AccessControl.g:251:2: ( 'categories' ':' categories= idList )
                # AccessControl.g:251:4: 'categories' ':' categories= idList
                pass 
                self.match(self.input, 29, self.FOLLOW_29_in_mlsCategories862)
                self.match(self.input, 27, self.FOLLOW_27_in_mlsCategories864)
                self._state.following.append(self.FOLLOW_idList_in_mlsCategories871)
                categories = self.idList()

                self._state.following.pop()
                #action start
                     
                categoryList = categories
                	   
                #action end




            except RecognitionException, re:
                self.reportError(re)
                self.recover(self.input, re)
        finally:

            pass
        return categoryList

    # $ANTLR end "mlsCategories"


    # $ANTLR start "mlsAssigns"
    # AccessControl.g:257:1: mlsAssigns returns [assignDecls] : ( 'assign' clearance= ID ':' category= ID ( ':' otherCategory= ID )* ( '-r' )? paths= pathList )+ ;
    def mlsAssigns(self, ):

        assignDecls = None

        clearance = None
        category = None
        otherCategory = None
        paths = None


               
        assignDecls = []
        recursive = False

        try:
            try:
                # AccessControl.g:262:2: ( ( 'assign' clearance= ID ':' category= ID ( ':' otherCategory= ID )* ( '-r' )? paths= pathList )+ )
                # AccessControl.g:262:4: ( 'assign' clearance= ID ':' category= ID ( ':' otherCategory= ID )* ( '-r' )? paths= pathList )+
                pass 
                # AccessControl.g:262:4: ( 'assign' clearance= ID ':' category= ID ( ':' otherCategory= ID )* ( '-r' )? paths= pathList )+
                cnt19 = 0
                while True: #loop19
                    alt19 = 2
                    LA19_0 = self.input.LA(1)

                    if (LA19_0 == 21) :
                        alt19 = 1


                    if alt19 == 1:
                        # AccessControl.g:263:9: 'assign' clearance= ID ':' category= ID ( ':' otherCategory= ID )* ( '-r' )? paths= pathList
                        pass 
                        self.match(self.input, 21, self.FOLLOW_21_in_mlsAssigns909)
                        clearance=self.match(self.input, ID, self.FOLLOW_ID_in_mlsAssigns915)
                        self.match(self.input, 27, self.FOLLOW_27_in_mlsAssigns917)
                        category=self.match(self.input, ID, self.FOLLOW_ID_in_mlsAssigns933)
                        #action start
                                    
                        categorySet = set()
                        categorySet.add(category.text)
                                   
                        #action end
                        # AccessControl.g:269:9: ( ':' otherCategory= ID )*
                        while True: #loop17
                            alt17 = 2
                            LA17_0 = self.input.LA(1)

                            if (LA17_0 == 27) :
                                alt17 = 1


                            if alt17 == 1:
                                # AccessControl.g:269:10: ':' otherCategory= ID
                                pass 
                                self.match(self.input, 27, self.FOLLOW_27_in_mlsAssigns959)
                                otherCategory=self.match(self.input, ID, self.FOLLOW_ID_in_mlsAssigns965)
                                #action start
                                            
                                categorySet.add(otherCategory.text)
                                           
                                #action end


                            else:
                                break #loop17
                        # AccessControl.g:274:10: ( '-r' )?
                        alt18 = 2
                        LA18_0 = self.input.LA(1)

                        if (LA18_0 == 22) :
                            alt18 = 1
                        if alt18 == 1:
                            # AccessControl.g:274:11: '-r'
                            pass 
                            self.match(self.input, 22, self.FOLLOW_22_in_mlsAssigns1004)
                            #action start
                                         
                            recursive = True
                                        
                            #action end



                        self._state.following.append(self.FOLLOW_pathList_in_mlsAssigns1046)
                        paths = self.pathList()

                        self._state.following.pop()
                        #action start
                                     
                        for path in paths :
                           assignDecls.append(MLSAssignment(path,clearance.text,categorySet,recursive))
                                    
                        #action end


                    else:
                        if cnt19 >= 1:
                            break #loop19

                        eee = EarlyExitException(19, self.input)
                        raise eee

                    cnt19 += 1




            except RecognitionException, re:
                self.reportError(re)
                self.recover(self.input, re)
        finally:

            pass
        return assignDecls

    # $ANTLR end "mlsAssigns"


    # $ANTLR start "mlsUsers"
    # AccessControl.g:287:1: mlsUsers returns [userDecls] : ( 'users' clearance= ID ':' category= ID ( ':' otherCategory= ID )* userList= idList )+ ;
    def mlsUsers(self, ):

        userDecls = None

        clearance = None
        category = None
        otherCategory = None
        userList = None


               
        userDecls = []

        try:
            try:
                # AccessControl.g:291:2: ( ( 'users' clearance= ID ':' category= ID ( ':' otherCategory= ID )* userList= idList )+ )
                # AccessControl.g:291:4: ( 'users' clearance= ID ':' category= ID ( ':' otherCategory= ID )* userList= idList )+
                pass 
                # AccessControl.g:291:4: ( 'users' clearance= ID ':' category= ID ( ':' otherCategory= ID )* userList= idList )+
                cnt21 = 0
                while True: #loop21
                    alt21 = 2
                    LA21_0 = self.input.LA(1)

                    if (LA21_0 == 30) :
                        alt21 = 1


                    if alt21 == 1:
                        # AccessControl.g:292:5: 'users' clearance= ID ':' category= ID ( ':' otherCategory= ID )* userList= idList
                        pass 
                        self.match(self.input, 30, self.FOLLOW_30_in_mlsUsers1096)
                        clearance=self.match(self.input, ID, self.FOLLOW_ID_in_mlsUsers1102)
                        self.match(self.input, 27, self.FOLLOW_27_in_mlsUsers1104)
                        category=self.match(self.input, ID, self.FOLLOW_ID_in_mlsUsers1115)
                        #action start
                                 
                        categoryList = []
                        categoryList.append(category.text)
                        	       
                        #action end
                        # AccessControl.g:298:6: ( ':' otherCategory= ID )*
                        while True: #loop20
                            alt20 = 2
                            LA20_0 = self.input.LA(1)

                            if (LA20_0 == 27) :
                                alt20 = 1


                            if alt20 == 1:
                                # AccessControl.g:298:7: ':' otherCategory= ID
                                pass 
                                self.match(self.input, 27, self.FOLLOW_27_in_mlsUsers1135)
                                otherCategory=self.match(self.input, ID, self.FOLLOW_ID_in_mlsUsers1141)
                                #action start
                                         
                                categoryList.append(otherCategory.text)
                                	       
                                #action end


                            else:
                                break #loop20
                        self._state.following.append(self.FOLLOW_idList_in_mlsUsers1172)
                        userList = self.idList()

                        self._state.following.pop()
                        #action start
                                 
                        for user in userList :
                            userDecls.append(MLSUserDeclaration(user,clearance.text,categoryList))
                        	        
                        #action end


                    else:
                        if cnt21 >= 1:
                            break #loop21

                        eee = EarlyExitException(21, self.input)
                        raise eee

                    cnt21 += 1




            except RecognitionException, re:
                self.reportError(re)
                self.recover(self.input, re)
        finally:

            pass
        return userDecls

    # $ANTLR end "mlsUsers"


    # Delegated rules


 

    FOLLOW_dtelSpec_in_accessControlSpec56 = frozenset([1])
    FOLLOW_mlsSpec_in_accessControlSpec69 = frozenset([1])
    FOLLOW_dtelType_in_dtelSpec100 = frozenset([9, 12])
    FOLLOW_dtelDomain_in_dtelSpec126 = frozenset([12, 20])
    FOLLOW_dtelInitial_in_dtelSpec147 = frozenset([21])
    FOLLOW_dtelAssign_in_dtelSpec163 = frozenset([1, 21])
    FOLLOW_9_in_dtelType196 = frozenset([4])
    FOLLOW_idList_in_dtelType202 = frozenset([10])
    FOLLOW_10_in_dtelType204 = frozenset([1])
    FOLLOW_ID_in_idList232 = frozenset([1, 11])
    FOLLOW_11_in_idList243 = frozenset([4])
    FOLLOW_ID_in_idList249 = frozenset([1, 11])
    FOLLOW_12_in_dtelDomain282 = frozenset([4])
    FOLLOW_ID_in_dtelDomain288 = frozenset([13])
    FOLLOW_13_in_dtelDomain290 = frozenset([14])
    FOLLOW_14_in_dtelDomain292 = frozenset([5])
    FOLLOW_pathList_in_dtelDomain298 = frozenset([15])
    FOLLOW_15_in_dtelDomain300 = frozenset([10, 11])
    FOLLOW_11_in_dtelDomain309 = frozenset([14])
    FOLLOW_14_in_dtelDomain311 = frozenset([4, 18, 19])
    FOLLOW_permissionAttr_in_dtelDomain319 = frozenset([15])
    FOLLOW_transitionAttr_in_dtelDomain344 = frozenset([15])
    FOLLOW_15_in_dtelDomain360 = frozenset([10, 11])
    FOLLOW_11_in_dtelDomain374 = frozenset([16])
    FOLLOW_16_in_dtelDomain376 = frozenset([10, 11])
    FOLLOW_11_in_dtelDomain396 = frozenset([14])
    FOLLOW_14_in_dtelDomain398 = frozenset([4, 18, 19])
    FOLLOW_permissionAttr_in_dtelDomain406 = frozenset([15])
    FOLLOW_transitionAttr_in_dtelDomain431 = frozenset([15])
    FOLLOW_15_in_dtelDomain447 = frozenset([10, 11])
    FOLLOW_10_in_dtelDomain457 = frozenset([1])
    FOLLOW_ID_in_permissionAttr488 = frozenset([17])
    FOLLOW_17_in_permissionAttr490 = frozenset([4])
    FOLLOW_idList_in_permissionAttr497 = frozenset([1])
    FOLLOW_18_in_transitionAttr523 = frozenset([17])
    FOLLOW_19_in_transitionAttr535 = frozenset([17])
    FOLLOW_17_in_transitionAttr546 = frozenset([4])
    FOLLOW_idList_in_transitionAttr553 = frozenset([1])
    FOLLOW_20_in_dtelInitial573 = frozenset([13])
    FOLLOW_13_in_dtelInitial575 = frozenset([4])
    FOLLOW_ID_in_dtelInitial581 = frozenset([10])
    FOLLOW_10_in_dtelInitial583 = frozenset([1])
    FOLLOW_21_in_dtelAssign606 = frozenset([4, 22, 23])
    FOLLOW_22_in_dtelAssign611 = frozenset([4, 23])
    FOLLOW_23_in_dtelAssign624 = frozenset([4])
    FOLLOW_ID_in_dtelAssign638 = frozenset([5])
    FOLLOW_pathList_in_dtelAssign644 = frozenset([10])
    FOLLOW_10_in_dtelAssign646 = frozenset([1])
    FOLLOW_path_in_pathList675 = frozenset([1, 11])
    FOLLOW_11_in_pathList684 = frozenset([5])
    FOLLOW_path_in_pathList690 = frozenset([1, 11])
    FOLLOW_PATHPREFIX_in_path722 = frozenset([1, 24])
    FOLLOW_24_in_path726 = frozenset([4])
    FOLLOW_idList_in_path732 = frozenset([25])
    FOLLOW_25_in_path734 = frozenset([1])
    FOLLOW_mlsClearances_in_mlsSpec759 = frozenset([29])
    FOLLOW_mlsCategories_in_mlsSpec765 = frozenset([21])
    FOLLOW_mlsAssigns_in_mlsSpec771 = frozenset([30])
    FOLLOW_mlsUsers_in_mlsSpec777 = frozenset([1])
    FOLLOW_26_in_mlsClearances804 = frozenset([27])
    FOLLOW_27_in_mlsClearances806 = frozenset([4])
    FOLLOW_ID_in_mlsClearances815 = frozenset([1, 28])
    FOLLOW_28_in_mlsClearances828 = frozenset([4])
    FOLLOW_ID_in_mlsClearances834 = frozenset([1, 28])
    FOLLOW_29_in_mlsCategories862 = frozenset([27])
    FOLLOW_27_in_mlsCategories864 = frozenset([4])
    FOLLOW_idList_in_mlsCategories871 = frozenset([1])
    FOLLOW_21_in_mlsAssigns909 = frozenset([4])
    FOLLOW_ID_in_mlsAssigns915 = frozenset([27])
    FOLLOW_27_in_mlsAssigns917 = frozenset([4])
    FOLLOW_ID_in_mlsAssigns933 = frozenset([5, 22, 27])
    FOLLOW_27_in_mlsAssigns959 = frozenset([4])
    FOLLOW_ID_in_mlsAssigns965 = frozenset([5, 22, 27])
    FOLLOW_22_in_mlsAssigns1004 = frozenset([5])
    FOLLOW_pathList_in_mlsAssigns1046 = frozenset([1, 21])
    FOLLOW_30_in_mlsUsers1096 = frozenset([4])
    FOLLOW_ID_in_mlsUsers1102 = frozenset([27])
    FOLLOW_27_in_mlsUsers1104 = frozenset([4])
    FOLLOW_ID_in_mlsUsers1115 = frozenset([4, 27])
    FOLLOW_27_in_mlsUsers1135 = frozenset([4])
    FOLLOW_ID_in_mlsUsers1141 = frozenset([4, 27])
    FOLLOW_idList_in_mlsUsers1172 = frozenset([1, 30])



def main(argv, stdin=sys.stdin, stdout=sys.stdout, stderr=sys.stderr):
    from antlr3.main import ParserMain
    main = ParserMain("AccessControlLexer", AccessControlParser)
    main.stdin = stdin
    main.stdout = stdout
    main.stderr = stderr
    main.execute(argv)


if __name__ == '__main__':
    main(sys.argv)
