'''
Created on Oct 13, 2012

A set of file permissions

@author: Carr
'''
READ = 0 # read permission
WRITE = 1 # write permission
EXEC = 2 # execute permission
DIR = 3 # directory listing permission
CREATE = 4 # file creation permission

class FilePermissionSet(set):

    def __init__(self) :
  
        self.intRep = 0 # the bit representation of the set
        
    def setReadPermission(self) : self.add(READ)
    def setWritePermission(self) : self .add(WRITE)
    def setExecPermission(self) : self .add(EXEC)
    def setDirPermission(self) : self .add(DIR)
    def setCreatePermission(self) : self.add(CREATE)
    
    def hasReadPermission(self) : return READ in self
    def hasWritePermission(self) : return WRITE in self
    def hasExecPermission(self) : return EXEC in self
    def hasDirPermission(self) : return DIR in self
    def hasCreatePermission(self) : return CREATE in self
    
    def getIntRep(self) :
        '''
        Create and return the bit representation of the set
        '''
        
        if (self.intRep == 0) :
            if (self.hasReadPermission()) :
                intRep = 1
            
            if (self.hasWritePermission()) :
                intRep = ((intRep << 1) | 0x1)
            else :
                intRep <<= 1
            
            if (self.hasExecPermission()) :
                intRep =  ((intRep << 1) | 0x1)
            else :
                intRep <<= 1
                
            if (self.hasDirPermission()) :
                intRep = ((intRep << 1) | 0x1)
            else :
                intRep <<= 1
            
            if (self.hasCreatePermission()) :
                intRep = ((intRep << 1) | 0x1)
            else :
                intRep <<= 1
            
        return intRep
    
    def getListRep(self) : 
        '''
        Create and return a boolean list representation of the set
        '''
        retList = [False,False,False,False,False]
        if self.hasReadPermission()  : retList[0] = True
        if self.hasWritePermission() : retList[1] = True
        if self.hasExecPermission() : retList[2] = True
        if self.hasDirPermission() : retList[3] = True
        if self.hasCreatePermission() : retList[4] = True

        return retList
    


        