'''
Created on Oct 11, 2012

A leaf node in the directory tree
@author: carr
'''
from DirTreeNode import DirTreeNode

class DirTreeLeafNode(DirTreeNode):
 
    def __init__(self, parentName) :
        '''
        
        :param parentName: the name associated with the parent of this node
        '''
        self.name = "__leaf_"+parentName
        self.typeId = -1 # a nuique type identifier
        self.levelId = -1 # a unique security level identifier
        self.flags = 0 # is the assignment static or recursive

    def findChild(self, name) :
        '''
        Leaf nodes do not have children
        :param name: ignored
        '''
        return -1
           
  
    def findSubTree(self, path) :
        '''
        Leaf nodes do not have subtrees
        :param path: ignored
        '''
        return -1

    def assignType(self, typeId, flags) :
        '''
        Set the type of this node
        :param typeId: a unique type identifer
        :param flags: is the assignment static or recursive
        '''
        self.setType(typeId,flags)
  
    def assignSecurityLevel(self, levelId, flags) :
        '''
        Set the security level  of this node
        :param typeId: a unique security level  identifer
        :param flags: is the assignment srecursive
        '''
        self.levelId = levelId
        self.flags = flags
  
    def addToTree(self, path):
        '''
        Do nothing
        :param path: ignored
        '''
        return 0
    