/*
 * Decompiled with CFR 0.152.
 */
package util;

import dtel.DTELSpecification;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import util.DirTreeLeafNode;
import util.DirTreeNode;

public class DirTreeInteriorNode
extends DirTreeNode {
    public DirTreeInteriorNode(String name) {
        this.name = new String(name);
        this.typeId = -1;
        this.flags = 0;
        this.children = new LinkedList();
        this.nodeId = numNodes++;
    }

    public DirTreeInteriorNode addChild(String name) {
        DirTreeInteriorNode child = new DirTreeInteriorNode(name);
        this.children.add(child);
        return child;
    }

    private void addLeaf(String name) {
        DirTreeLeafNode child = new DirTreeLeafNode(name);
        this.children.add(child);
    }

    private DirTreeLeafNode getLeaf() {
        Iterator cIter = this.children.iterator();
        DirTreeNode child = (DirTreeNode)cIter.next();
        while (cIter.hasNext() && !(child instanceof DirTreeLeafNode)) {
            child = (DirTreeNode)cIter.next();
        }
        if (child instanceof DirTreeLeafNode) {
            return (DirTreeLeafNode)child;
        }
        return null;
    }

    private String getPrefix(String path) {
        int slashIndex = path.indexOf(47);
        String name = slashIndex == -1 ? path : path.substring(0, slashIndex);
        return name;
    }

    private String getSuffix(String path) {
        int slashIndex = path.indexOf(47);
        if (slashIndex == -1) {
            return new String("");
        }
        return path.substring(slashIndex + 1);
    }

    @Override
    public DirTreeNode findChild(String name) {
        DirTreeNode child = null;
        Iterator cIter = this.children.iterator();
        while (child == null && cIter.hasNext()) {
            DirTreeNode node = (DirTreeNode)cIter.next();
            if (!name.equals(node.getName())) continue;
            child = node;
        }
        return child;
    }

    @Override
    public DirTreeNode findSubTree(String path) {
        String name = this.getPrefix(path);
        DirTreeNode subTree = this.findChild(name);
        if (subTree == null) {
            return null;
        }
        if (!(path = this.getSuffix(path)).isEmpty()) {
            return subTree.findSubTree(path);
        }
        return subTree;
    }

    @Override
    public void assignType(int typeId, int flags) {
        this.typeId = typeId;
        this.flags = flags;
        if ((flags & DTELSpecification.RECURSIVE) != 0) {
            Iterator cIter = this.children.iterator();
            while (cIter.hasNext()) {
                ((DirTreeNode)cIter.next()).assignType(typeId, flags);
            }
        } else {
            DirTreeLeafNode leaf = this.getLeaf();
            if (leaf != null) {
                leaf.assignType(typeId, flags);
            }
        }
    }

    protected static void emitTreeNodes(DirTreeNode node) throws IOException {
        LinkedList<DirTreeNode> queue = new LinkedList<DirTreeNode>();
        queue.add(node);
        while (!queue.isEmpty()) {
            DirTreeNode dirNode = (DirTreeNode)queue.remove();
            dirNode.emitTreeNodeInfo();
            queue.addAll(dirNode.children);
        }
    }

    @Override
    public void addToTree(String path) {
        if (path.isEmpty()) {
            this.addLeaf(this.getName());
        } else {
            String name = this.getPrefix(path);
            DirTreeNode child = this.findChild(name);
            if (child == null) {
                child = this.addChild(name);
            }
            path = this.getSuffix(path);
            child.addToTree(path);
        }
    }
}

