/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.nio.ByteBuffer;
import util.DTELError;
import util.DirTreeInteriorNode;
import util.DirTreeNode;

public class DirTree {
    private DirTreeNode root = null;

    public DirTreeNode getRoot() {
        return this.root;
    }

    public void addPath(String path) throws DTELError {
        if (path.startsWith("/")) {
            if (this.root == null) {
                this.root = new DirTreeInteriorNode("");
            }
        } else {
            throw new DTELError("Invalid path: " + path);
        }
        path = path.substring(1);
        this.root.addToTree(path);
    }

    public DirTreeNode findSubTree(String path) throws DTELError {
        if (path.startsWith("/")) {
            if ((path = path.substring(1)).equals(this.root.getName())) {
                return this.root;
            }
            return this.root.findSubTree(path);
        }
        throw new DTELError("Invalid path: " + path);
    }

    public void assignTypeToSubtree(String path, int typeId, int flags) throws DTELError {
        DirTreeNode node = this.findSubTree(path);
        if (node != null) {
            node.assignType(typeId, flags);
        }
    }

    public void emitTree() throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.clear();
        bb.putInt(DirTreeNode.getNumNodes());
        System.out.write(bb.array());
        DirTreeNode.emitTreeNodes(this.root);
    }

    public void printTree() {
        DirTreeNode.printNodes(this.root);
    }
}

