/*
 * Decompiled with CFR 0.152.
 */
package dtel;

import dtel.Domain;
import dtel.EntryPointAttribute;
import dtel.PermissionAttribute;
import dtel.TransitionAttribute;
import dtel.TypeAssignment;
import dtel.TypeDeclaration;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import util.DTELError;
import util.DirTree;

public class DTELSpecification {
    public static int RECURSIVE = 2;
    public static int STATIC = 1;
    private LinkedList<TypeDeclaration> types;
    private LinkedList<Domain> domains;
    private LinkedList<TypeAssignment> assignments;
    private String initialDomain;
    private DirTree pathTree;
    private HashMap<String, Integer> typeMap = new HashMap();
    private HashMap<String, Integer> domainMap = new HashMap();

    public DTELSpecification(LinkedList<TypeDeclaration> types, LinkedList<Domain> domains, LinkedList<TypeAssignment> assignments, String initialDomain) {
        this.types = new LinkedList<TypeDeclaration>(types);
        this.domains = new LinkedList<Domain>(domains);
        this.assignments = new LinkedList<TypeAssignment>(assignments);
        this.initialDomain = new String(initialDomain);
        this.pathTree = new DirTree();
        this.buildTypeTable();
        this.buildDomainTable();
        try {
            this.buildDirectoryTree();
        }
        catch (DTELError e) {
            System.err.println("DTEL Spec Error:" + e.getMessage());
            System.exit(-1);
        }
    }

    private void buildTypeTable() {
        Iterator typeDecls = this.types.iterator();
        int i = 0;
        while (typeDecls.hasNext()) {
            TypeDeclaration decl = (TypeDeclaration)typeDecls.next();
            for (String type : decl.getTypeList()) {
                this.typeMap.put(type, i++);
            }
        }
    }

    private void buildDomainTable() {
        Iterator domIter = this.domains.iterator();
        int i = 0;
        while (domIter.hasNext()) {
            Domain domain = (Domain)domIter.next();
            this.domainMap.put(domain.getName(), i++);
        }
    }

    private void buildDirectoryTree() throws DTELError {
        for (TypeAssignment type : this.assignments) {
            for (String path : type.getPathList()) {
                this.pathTree.addPath(path);
            }
        }
        for (TypeAssignment type : this.assignments) {
            int flags;
            int n = flags = type.isRecursive() ? RECURSIVE : 0;
            if (type.isStatic()) {
                flags |= STATIC;
            }
            for (String path : type.getPathList()) {
                if (this.typeMap.get(type.getType()) == null) {
                    System.err.println("Use of invalid identifier '" + type.getType() + "' with assign statement. Aborting compilation.");
                    System.exit(-1);
                }
                this.pathTree.assignTypeToSubtree(path, this.typeMap.get(type.getType()), flags);
            }
        }
    }

    public void emitBinaryDTELSpec() throws IOException {
        this.emitTypeDefinitions();
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.clear();
        bb.putInt(this.domains.size());
        System.out.write(bb.array());
        for (Domain domain : this.domains) {
            bb.clear();
            bb.putInt(this.domainMap.get(domain.getName()));
            System.out.write(bb.array());
            bb.clear();
            bb.putInt(domain.getName().length());
            System.out.write(bb.array());
            byte[] nameBytes = domain.getName().getBytes();
            System.out.write(nameBytes);
            this.emitDomainEntryPoints(domain);
            this.emitDomainPermissions(domain);
            this.emitDomainTransitions(domain);
            bb.clear();
            if (domain.isSetAuth()) {
                bb.putInt(1);
            } else {
                bb.putInt(0);
            }
            System.out.write(bb.array());
        }
        bb.clear();
        bb.putInt(this.initialDomain.length());
        System.out.write(bb.array());
        byte[] nameBytes = this.initialDomain.getBytes();
        System.out.write(nameBytes);
        this.pathTree.emitTree();
    }

    private void emitDomainEntryPoints(Domain domain) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.clear();
        bb.putInt(domain.getEntryPoints().size());
        System.out.write(bb.array());
        for (EntryPointAttribute entryAttr : domain.getEntryPoints()) {
            bb.clear();
            bb.putInt(entryAttr.getEntryPoint().length());
            System.out.write(bb.array());
            byte[] entryBytes = entryAttr.getEntryPoint().getBytes();
            System.out.write(entryBytes);
        }
    }

    private void emitDomainPermissions(Domain domain) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(4);
        Iterator permIter = domain.getPermissions().iterator();
        bb.clear();
        bb.putInt(domain.getPermissions().size());
        System.out.write(bb.array());
        while (permIter.hasNext()) {
            PermissionAttribute permission = (PermissionAttribute)permIter.next();
            bb.clear();
            bb.putInt(permission.getPermissionRep());
            System.out.write(bb.array());
            Iterator typeIter = permission.getTypes().iterator();
            bb.clear();
            bb.putInt(permission.getTypes().size());
            System.out.write(bb.array());
            while (typeIter.hasNext()) {
                String type = (String)typeIter.next();
                bb.clear();
                bb.putInt(this.typeMap.get(type));
                System.out.write(bb.array());
            }
        }
    }

    private void emitDomainTransitions(Domain domain) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(4);
        Iterator transIter = domain.getTransitions().iterator();
        bb.clear();
        bb.putInt(domain.getTransitions().size());
        System.out.write(bb.array());
        while (transIter.hasNext()) {
            TransitionAttribute transition = (TransitionAttribute)transIter.next();
            bb.clear();
            bb.putInt(transition.getTransTypeRep());
            System.out.write(bb.array());
            bb.clear();
            bb.putInt(transition.getDomains().size());
            System.out.write(bb.array());
            for (String dName : transition.getDomains()) {
                bb.clear();
                bb.putInt(this.domainMap.get(dName));
                System.out.write(bb.array());
            }
        }
    }

    private void emitTypeDefinitions() throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.clear();
        bb.putInt(this.typeMap.size());
        System.out.write(bb.array());
        for (String key : this.typeMap.keySet()) {
            bb.clear();
            bb.putInt(this.typeMap.get(key));
            System.out.write(bb.array());
            bb.clear();
            bb.putInt(key.length());
            System.out.write(bb.array());
            byte[] keyBytes = key.getBytes();
            System.out.write(keyBytes);
        }
    }

    public void printDTELSpec() throws IOException {
        this.printTypeDefinitions();
        System.out.println("\nNumber of Domains: " + this.domains.size());
        for (Domain domain : this.domains) {
            System.out.println("\nDomain: " + this.domainMap.get(domain.getName()));
            System.out.println("\tName: " + domain.getName());
            this.printDomainEntryPoints(domain);
            this.printDomainPermissions(domain);
            this.printDomainTransitions(domain);
            if (!domain.isSetAuth()) continue;
            System.out.println("\tsetauth");
        }
        System.out.println("Initial domain: " + this.initialDomain);
        this.pathTree.printTree();
    }

    private void printTypeDefinitions() throws IOException {
        for (String key : this.typeMap.keySet()) {
            System.out.println("Type " + this.typeMap.get(key) + ": " + key);
        }
    }

    private void printDomainEntryPoints(Domain domain) throws IOException {
        for (EntryPointAttribute entryAttr : domain.getEntryPoints()) {
            System.out.println("\t\tEntry point: " + entryAttr.getEntryPoint());
        }
    }

    private void printDomainPermissions(Domain domain) throws IOException {
        for (PermissionAttribute permission : domain.getPermissions()) {
            System.out.println("\t\tPermissions: " + permission.getPermissionRep());
            for (String type : permission.getTypes()) {
                System.out.println("\t\t\tType: " + this.typeMap.get(type));
            }
        }
    }

    private void printDomainTransitions(Domain domain) throws IOException {
        for (TransitionAttribute transition : domain.getTransitions()) {
            System.out.println("\t\tTransition: " + transition.getTransTypeRep());
            for (String dName : transition.getDomains()) {
                System.out.println("\t\t\t Domain: " + this.domainMap.get(dName));
            }
        }
    }

    public void errorCheck() {
        System.err.println("Performing error checking...");
        ArrayList<String> errorMessages = new ArrayList<String>();
        Boolean errorsFound = false;
        for (String itn : this.domainMap.keySet()) {
            if (this.typeMap.get(itn) == null) continue;
            errorMessages.add("Type and domain lists both contain identifier '" + itn + "'");
            errorsFound = true;
        }
        if (this.domainMap.get(this.initialDomain) == null) {
            errorMessages.add("initial_domain set to '" + this.initialDomain + "' which is not defined as a domain");
            errorsFound = true;
        }
        for (Domain domain : this.domains) {
            for (PermissionAttribute permission : domain.getPermissions()) {
                for (String type : permission.getTypes()) {
                    if (this.typeMap.get(type) != null) continue;
                    errorMessages.add("Permissions tried to reference undefined type '" + type + "'");
                    errorsFound = true;
                }
            }
            for (TransitionAttribute transition : domain.getTransitions()) {
                for (String dName : transition.getDomains()) {
                    if (this.domainMap.get(dName) != null) continue;
                    errorMessages.add("Attempted exec or auto transition to '" + dName + "' which is not defined as a domain");
                    errorsFound = true;
                }
            }
        }
        if (errorsFound.booleanValue()) {
            System.err.println("The following errors were found:");
            for (String err : errorMessages) {
                System.err.println(err);
            }
            System.exit(-1);
        }
        System.err.println("No semantic errors found.");
    }

    public void emitJSM() throws IOException {
        System.out.println("class DTESecurityManager extends SecurityManager {");
        System.out.println("}");
    }
}

