/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public abstract class DirTreeNode {
    protected static int numNodes = 0;
    protected int nodeId;
    protected String name;
    protected int typeId;
    protected int flags;
    protected LinkedList<DirTreeNode> children;

    public static int getNumNodes() {
        return numNodes;
    }

    protected static void printNodes(DirTreeNode node) {
        LinkedList<DirTreeNode> queue = new LinkedList<DirTreeNode>();
        queue.add(node);
        while (!queue.isEmpty()) {
            DirTreeNode dirNode = (DirTreeNode)queue.remove();
            dirNode.printInfo();
            queue.addAll(dirNode.children);
        }
    }

    protected static void emitTreeNodes(DirTreeNode node) throws IOException {
        LinkedList<DirTreeNode> queue = new LinkedList<DirTreeNode>();
        queue.add(node);
        while (!queue.isEmpty()) {
            DirTreeNode dirNode = (DirTreeNode)queue.remove();
            dirNode.emitTreeNodeInfo();
            queue.addAll(dirNode.children);
        }
    }

    public void setType(int typeId, int flags) {
        this.typeId = typeId;
        this.flags = flags;
    }

    public int getId() {
        return this.nodeId;
    }

    public String getName() {
        return this.name;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public int getAssignType() {
        return this.flags;
    }

    public abstract DirTreeNode findChild(String var1);

    public abstract DirTreeNode findSubTree(String var1);

    public abstract void assignType(int var1, int var2);

    public void emitTreeNodeInfo() throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.clear();
        bb.putInt(this.nodeId);
        System.out.write(bb.array());
        bb.clear();
        bb.putInt(this.children.size());
        System.out.write(bb.array());
        bb.clear();
        bb.putInt(this.name.length());
        System.out.write(bb.array());
        byte[] nameBytes = this.name.getBytes();
        System.out.write(nameBytes);
        bb.clear();
        bb.putInt(this.typeId);
        System.out.write(bb.array());
        bb.clear();
        bb.putInt(this.flags);
        System.out.write(bb.array());
    }

    protected void printInfo() {
        System.out.println("Node Id: " + this.nodeId);
        System.out.println("\tNumber of children: " + this.children.size());
        System.out.println("\tNode name: " + this.name);
        System.out.println("\tType id: " + this.typeId);
        System.out.println("\tFlags: " + this.flags);
    }

    public abstract void addToTree(String var1);
}

