/*
 * Decompiled with CFR 0.152.
 */
package parser;

import dtel.DTELSpecification;
import dtel.Domain;
import dtel.EntryPointAttribute;
import dtel.FilePermissionSet;
import dtel.PermissionAttribute;
import dtel.TransitionAttribute;
import dtel.TypeAssignment;
import dtel.TypeDeclaration;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import parser.DTELParserConstants;
import parser.DTELParserTokenManager;
import parser.ParseException;
import parser.SimpleCharStream;
import parser.Token;

public class DTELParser
implements DTELParserConstants {
    private static String initialDomain = null;
    private static boolean jj_initialized_once = false;
    public static DTELParserTokenManager token_source;
    static SimpleCharStream jj_input_stream;
    public static Token token;
    public static Token jj_nt;
    private static int jj_ntk;
    private static Token jj_scanpos;
    private static Token jj_lastpos;
    private static int jj_la;
    private static int jj_gen;
    private static final int[] jj_la1;
    private static int[] jj_la1_0;
    private static final JJCalls[] jj_2_rtns;
    private static boolean jj_rescan;
    private static int jj_gc;
    private static final LookaheadSuccess jj_ls;
    private static List<int[]> jj_expentries;
    private static int[] jj_expentry;
    private static int jj_kind;
    private static int[] jj_lasttokens;
    private static int jj_endpos;

    static {
        jj_la1 = new int[12];
        DTELParser.jj_la1_init_0();
        jj_2_rtns = new JJCalls[2];
        jj_rescan = false;
        jj_gc = 0;
        jj_ls = new LookaheadSuccess();
        jj_expentries = new ArrayList<int[]>();
        jj_kind = -1;
        jj_lasttokens = new int[100];
    }

    private static void parsePermissions(FilePermissionSet perms, String flags, int line, int column) throws ParseException {
        int i = 0;
        while (i < flags.length()) {
            switch (flags.charAt(i)) {
                case 'r': {
                    perms.setReadPermission();
                    break;
                }
                case 'w': {
                    perms.setWritePermission();
                    break;
                }
                case 'x': {
                    perms.setExecPermission();
                    break;
                }
                case 'c': {
                    perms.setCreatePermission();
                    break;
                }
                case 'd': {
                    perms.setDirPermission();
                    break;
                }
                default: {
                    throw new ParseException("Encountered " + flags.charAt(i) + "at line " + line + ", column " + (column + i) + ".\nWas expecting one of: c,r,w,x,d");
                }
            }
            ++i;
        }
    }

    public static void main(String[] args) throws ParseException, FileNotFoundException, IOException {
        InputStream input = System.in;
        DTELSpecification dtelSpec = null;
        int i = 0;
        while (i < args.length - 1) {
            ++i;
        }
        if (args.length > 0) {
            input = new FileInputStream(args[args.length - 1]);
            System.err.println("Reading from " + args[args.length - 1]);
        } else {
            System.err.println("Reading from stdin");
        }
        DTELParser parser = new DTELParser(input);
        try {
            dtelSpec = DTELParser.dtel();
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        dtelSpec.errorCheck();
        if (args.length > 1 && args[0].equals("-jsm")) {
            System.err.println("Test: emit JSM");
        } else {
            dtelSpec.emitBinaryDTELSpec();
        }
    }

    public static final DTELSpecification dtel() throws ParseException {
        LinkedList<TypeAssignment> typeAssignments = new LinkedList<TypeAssignment>();
        LinkedList<Domain> domains = new LinkedList<Domain>();
        LinkedList<TypeDeclaration> types = new LinkedList<TypeDeclaration>();
        TypeDeclaration typeDecl = null;
        Domain dom = null;
        TypeAssignment assignment = null;
        block9: while (true) {
            typeDecl = DTELParser.type();
            types.add(typeDecl);
            switch (jj_ntk == -1 ? DTELParser.jj_ntk() : jj_ntk) {
                case 6: {
                    continue block9;
                }
            }
            break;
        }
        DTELParser.jj_la1[0] = jj_gen;
        block10: while (true) {
            dom = DTELParser.domain();
            domains.add(dom);
            switch (jj_ntk == -1 ? DTELParser.jj_ntk() : jj_ntk) {
                case 7: {
                    continue block10;
                }
            }
            break;
        }
        DTELParser.jj_la1[1] = jj_gen;
        DTELParser.initial();
        block11: while (true) {
            assignment = DTELParser.assign();
            typeAssignments.add(assignment);
            switch (jj_ntk == -1 ? DTELParser.jj_ntk() : jj_ntk) {
                case 8: {
                    continue block11;
                }
            }
            break;
        }
        DTELParser.jj_la1[2] = jj_gen;
        return new DTELSpecification(types, domains, typeAssignments, initialDomain);
    }

    public static final TypeDeclaration type() throws ParseException {
        DTELParser.jj_consume_token(6);
        LinkedList<String> typeList = DTELParser.id_list();
        DTELParser.jj_consume_token(19);
        return new TypeDeclaration(typeList);
    }

    public static final LinkedList<String> id_list() throws ParseException {
        Token id = null;
        id = DTELParser.jj_consume_token(26);
        LinkedList<String> idList = new LinkedList<String>();
        idList.add(id.image);
        while (DTELParser.jj_2_1(2)) {
            DTELParser.jj_consume_token(17);
            id = DTELParser.jj_consume_token(26);
            idList.add(id.image);
        }
        return idList;
    }

    public static final Domain domain() throws ParseException {
        LinkedList<PermissionAttribute> permissions = new LinkedList<PermissionAttribute>();
        LinkedList<TransitionAttribute> transitions = new LinkedList<TransitionAttribute>();
        LinkedList<EntryPointAttribute> entryPoints = new LinkedList<EntryPointAttribute>();
        PermissionAttribute permission = null;
        TransitionAttribute transition = null;
        boolean setauth = false;
        DTELParser.jj_consume_token(7);
        Token domainName = DTELParser.jj_consume_token(26);
        DTELParser.jj_consume_token(20);
        DTELParser.jj_consume_token(13);
        LinkedList<String> paths = DTELParser.path_list();
        DTELParser.jj_consume_token(14);
        Iterator pIter = paths.iterator();
        while (pIter.hasNext()) {
            entryPoints.add(new EntryPointAttribute((String)pIter.next()));
        }
        while (DTELParser.jj_2_2(2)) {
            DTELParser.jj_consume_token(17);
            DTELParser.jj_consume_token(13);
            switch (jj_ntk == -1 ? DTELParser.jj_ntk() : jj_ntk) {
                case 26: {
                    permission = DTELParser.permissionAttr();
                    permissions.add(permission);
                    break;
                }
                case 9: 
                case 10: {
                    transition = DTELParser.transitionAttr();
                    transitions.add(transition);
                    break;
                }
                default: {
                    DTELParser.jj_la1[3] = jj_gen;
                    DTELParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            DTELParser.jj_consume_token(14);
        }
        block4 : switch (jj_ntk == -1 ? DTELParser.jj_ntk() : jj_ntk) {
            case 17: {
                DTELParser.jj_consume_token(17);
                DTELParser.jj_consume_token(11);
                setauth = true;
                while (true) {
                    switch (jj_ntk == -1 ? DTELParser.jj_ntk() : jj_ntk) {
                        case 17: {
                            break;
                        }
                        default: {
                            DTELParser.jj_la1[4] = jj_gen;
                            break block4;
                        }
                    }
                    DTELParser.jj_consume_token(17);
                    DTELParser.jj_consume_token(13);
                    switch (jj_ntk == -1 ? DTELParser.jj_ntk() : jj_ntk) {
                        case 26: {
                            permission = DTELParser.permissionAttr();
                            permissions.add(permission);
                            break;
                        }
                        case 9: 
                        case 10: {
                            transition = DTELParser.transitionAttr();
                            transitions.add(transition);
                            break;
                        }
                        default: {
                            DTELParser.jj_la1[5] = jj_gen;
                            DTELParser.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    DTELParser.jj_consume_token(14);
                }
            }
            default: {
                DTELParser.jj_la1[6] = jj_gen;
            }
        }
        DTELParser.jj_consume_token(19);
        return new Domain(domainName.image, entryPoints, permissions, transitions, setauth);
    }

    public static final PermissionAttribute permissionAttr() throws ParseException {
        FilePermissionSet perms = new FilePermissionSet();
        LinkedList<String> types = new LinkedList();
        Token flags = null;
        flags = DTELParser.jj_consume_token(26);
        DTELParser.jj_consume_token(18);
        types = DTELParser.id_list();
        DTELParser.parsePermissions(perms, flags.image, flags.beginLine, flags.beginColumn);
        return new PermissionAttribute(perms, types);
    }

    public static final TransitionAttribute transitionAttr() throws ParseException {
        boolean auto = false;
        boolean exec = false;
        switch (jj_ntk == -1 ? DTELParser.jj_ntk() : jj_ntk) {
            case 10: {
                DTELParser.jj_consume_token(10);
                auto = true;
                break;
            }
            case 9: {
                DTELParser.jj_consume_token(9);
                exec = true;
                break;
            }
            default: {
                DTELParser.jj_la1[7] = jj_gen;
                DTELParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        DTELParser.jj_consume_token(18);
        LinkedList<String> domains = DTELParser.id_list();
        return new TransitionAttribute(auto, exec, domains);
    }

    public static final void initial() throws ParseException {
        DTELParser.jj_consume_token(12);
        DTELParser.jj_consume_token(20);
        Token domain = DTELParser.jj_consume_token(26);
        DTELParser.jj_consume_token(19);
        initialDomain = new String(domain.image);
    }

    public static final TypeAssignment assign() throws ParseException {
        boolean recursiveOpt = false;
        boolean staticOpt = false;
        LinkedList<String> pathList = null;
        Token type = null;
        DTELParser.jj_consume_token(8);
        switch (jj_ntk == -1 ? DTELParser.jj_ntk() : jj_ntk) {
            case 22: {
                DTELParser.jj_consume_token(22);
                recursiveOpt = true;
                break;
            }
            default: {
                DTELParser.jj_la1[8] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? DTELParser.jj_ntk() : jj_ntk) {
            case 23: {
                DTELParser.jj_consume_token(23);
                staticOpt = true;
                break;
            }
            default: {
                DTELParser.jj_la1[9] = jj_gen;
            }
        }
        type = DTELParser.jj_consume_token(26);
        pathList = DTELParser.path_list();
        DTELParser.jj_consume_token(19);
        return new TypeAssignment(type.image, recursiveOpt, staticOpt, pathList);
    }

    public static final LinkedList<String> path_list() throws ParseException {
        LinkedList<String> pathList = new LinkedList<String>();
        LinkedList<String> pathNames = DTELParser.path();
        pathList.addAll(pathNames);
        block3: while (true) {
            switch (jj_ntk == -1 ? DTELParser.jj_ntk() : jj_ntk) {
                case 17: {
                    break;
                }
                default: {
                    DTELParser.jj_la1[10] = jj_gen;
                    break block3;
                }
            }
            DTELParser.jj_consume_token(17);
            pathNames = DTELParser.path();
            pathList.addAll(pathNames);
        }
        return pathList;
    }

    public static final LinkedList<String> path() throws ParseException {
        LinkedList<String> paths = new LinkedList<String>();
        LinkedList<Object> ids = new LinkedList();
        Token path = null;
        Token lbrace = null;
        path = DTELParser.jj_consume_token(27);
        switch (jj_ntk == -1 ? DTELParser.jj_ntk() : jj_ntk) {
            case 15: {
                lbrace = DTELParser.jj_consume_token(15);
                ids = DTELParser.id_list();
                DTELParser.jj_consume_token(16);
                break;
            }
            default: {
                DTELParser.jj_la1[11] = jj_gen;
            }
        }
        if (ids.size() == 0) {
            paths.add(path.image);
        } else {
            if (!path.image.endsWith("/")) {
                throw new ParseException("Encountered { at line " + lbrace.beginLine + ", column " + lbrace.beginColumn + ".\nWas expecting: /");
            }
            for (String string : ids) {
                paths.add(path.image.concat(string));
            }
        }
        return paths;
    }

    private static boolean jj_2_1(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !DTELParser.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
        finally {
            DTELParser.jj_save(0, xla);
        }
    }

    private static boolean jj_2_2(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !DTELParser.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
        finally {
            DTELParser.jj_save(1, xla);
        }
    }

    private static boolean jj_3_2() {
        if (DTELParser.jj_scan_token(17)) {
            return true;
        }
        return DTELParser.jj_scan_token(13);
    }

    private static boolean jj_3_1() {
        if (DTELParser.jj_scan_token(17)) {
            return true;
        }
        return DTELParser.jj_scan_token(26);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{64, 128, 256, 0x4000600, 131072, 0x4000600, 131072, 1536, 0x400000, 0x800000, 131072, 32768};
    }

    public DTELParser(InputStream stream) {
        this(stream, null);
    }

    public DTELParser(InputStream stream, String encoding) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        try {
            jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        token_source = new DTELParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int i = 0;
        while (i < 12) {
            DTELParser.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < jj_2_rtns.length) {
            DTELParser.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public static void ReInit(InputStream stream) {
        DTELParser.ReInit(stream, null);
    }

    public static void ReInit(InputStream stream, String encoding) {
        try {
            jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        DTELParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int i = 0;
        while (i < 12) {
            DTELParser.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < jj_2_rtns.length) {
            DTELParser.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public DTELParser(Reader stream) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new SimpleCharStream(stream, 1, 1);
        token_source = new DTELParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int i = 0;
        while (i < 12) {
            DTELParser.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < jj_2_rtns.length) {
            DTELParser.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public static void ReInit(Reader stream) {
        jj_input_stream.ReInit(stream, 1, 1);
        DTELParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int i = 0;
        while (i < 12) {
            DTELParser.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < jj_2_rtns.length) {
            DTELParser.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public DTELParser(DTELParserTokenManager tm) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int i = 0;
        while (i < 12) {
            DTELParser.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < jj_2_rtns.length) {
            DTELParser.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(DTELParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int i = 0;
        while (i < 12) {
            DTELParser.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < jj_2_rtns.length) {
            DTELParser.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    private static Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = token;
        token = oldToken.next != null ? DTELParser.token.next : (DTELParser.token.next = DTELParserTokenManager.getNextToken());
        jj_ntk = -1;
        if (DTELParser.token.kind == kind) {
            ++jj_gen;
            if (++jj_gc > 100) {
                jj_gc = 0;
                int i = 0;
                while (i < jj_2_rtns.length) {
                    JJCalls c = jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw DTELParser.generateParseException();
    }

    private static boolean jj_scan_token(int kind) {
        if (jj_scanpos == jj_lastpos) {
            --jj_la;
            if (DTELParser.jj_scanpos.next == null) {
                jj_scanpos = DTELParser.jj_scanpos.next = DTELParserTokenManager.getNextToken();
                jj_lastpos = DTELParser.jj_scanpos.next;
            } else {
                jj_lastpos = jj_scanpos = DTELParser.jj_scanpos.next;
            }
        } else {
            jj_scanpos = DTELParser.jj_scanpos.next;
        }
        if (jj_rescan) {
            int i = 0;
            Token tok = token;
            while (tok != null && tok != jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                DTELParser.jj_add_error_token(kind, i);
            }
        }
        if (DTELParser.jj_scanpos.kind != kind) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public static final Token getNextToken() {
        token = DTELParser.token.next != null ? DTELParser.token.next : (DTELParser.token.next = DTELParserTokenManager.getNextToken());
        jj_ntk = -1;
        ++jj_gen;
        return token;
    }

    public static final Token getToken(int index) {
        Token t = token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = DTELParserTokenManager.getNextToken());
            ++i;
        }
        return t;
    }

    private static int jj_ntk() {
        jj_nt = DTELParser.token.next;
        if (jj_nt == null) {
            DTELParser.token.next = DTELParserTokenManager.getNextToken();
            jj_ntk = DTELParser.token.next.kind;
            return jj_ntk;
        }
        jj_ntk = DTELParser.jj_nt.kind;
        return jj_ntk;
    }

    private static void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == jj_endpos + 1) {
            DTELParser.jj_lasttokens[DTELParser.jj_endpos++] = kind;
        } else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];
            int i = 0;
            while (i < jj_endpos) {
                DTELParser.jj_expentry[i] = jj_lasttokens[i];
                ++i;
            }
            block1: for (int[] oldentry : jj_expentries) {
                if (oldentry.length != jj_expentry.length) continue;
                int i2 = 0;
                while (i2 < jj_expentry.length) {
                    if (oldentry[i2] != jj_expentry[i2]) continue block1;
                    ++i2;
                }
                jj_expentries.add(jj_expentry);
                break;
            }
            if (pos != 0) {
                jj_endpos = pos;
                DTELParser.jj_lasttokens[DTELParser.jj_endpos - 1] = kind;
            }
        }
    }

    public static ParseException generateParseException() {
        jj_expentries.clear();
        boolean[] la1tokens = new boolean[28];
        if (jj_kind >= 0) {
            la1tokens[DTELParser.jj_kind] = true;
            jj_kind = -1;
        }
        int i = 0;
        while (i < 12) {
            if (jj_la1[i] == jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 28) {
            if (la1tokens[i]) {
                jj_expentry = new int[1];
                DTELParser.jj_expentry[0] = i;
                jj_expentries.add(jj_expentry);
            }
            ++i;
        }
        jj_endpos = 0;
        DTELParser.jj_rescan_token();
        DTELParser.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[jj_expentries.size()][];
        int i2 = 0;
        while (i2 < jj_expentries.size()) {
            exptokseq[i2] = jj_expentries.get(i2);
            ++i2;
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    public static final void enable_tracing() {
    }

    public static final void disable_tracing() {
    }

    private static void jj_rescan_token() {
        jj_rescan = true;
        int i = 0;
        while (i < 2) {
            try {
                JJCalls p = jj_2_rtns[i];
                do {
                    if (p.gen <= jj_gen) continue;
                    jj_la = p.arg;
                    jj_lastpos = jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            DTELParser.jj_3_1();
                            break;
                        }
                        case 1: {
                            DTELParser.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
            ++i;
        }
        jj_rescan = false;
    }

    private static void jj_save(int index, int xla) {
        JJCalls p = jj_2_rtns[index];
        while (p.gen > jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = jj_gen + xla - jj_la;
        p.first = token;
        p.arg = xla;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

