'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Yifei Li
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on Feb 8, 2012

@author: yifli
'''

from PyQt4.QtGui import QUndoCommand

class AddEdgeCommand(QUndoCommand):

    def __init__(self, item, description, scene):
        QUndoCommand.__init__(self)
        self.item = item
        self.start = item.startItem
        self.end = item.endItem
        self.scene = scene
        self.description = description
        
        
    def undo(self):
        self.start.edgeList.remove(self.item)
        self.end.edgeList.remove(self.item)
        self.scene.removeItem(self.item)
        self.scene.update()
    
    
    def redo(self):
        self.item.description = self.description
        self.start.edgeList.append(self.item)
        self.end.edgeList.append(self.item)
        self.scene.addItem(self.item)
        self.item.updatePosition()
        self.scene.update()
        