'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Yifei Li
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on Feb 3, 2012

@author: yifli
'''
from PyQt4.QtGui import QUndoCommand, QMessageBox
from FileNode import FileNode
from EdgeItem import EdgeItem
import string

class ChangeNameCommand(QUndoCommand):
    '''
    Changes the name of a type node / domain node / file node / edge
    '''

    def __init__(self, item, name, parent = None):
        QUndoCommand.__init__(self, parent)
        self.item = item
        self.name = str(name)
        if not isinstance(item, EdgeItem):  
            self.oldname = self.item.name   
        else:
            self.oldname = self.item.description
            
    
    def undo(self):
        if not isinstance(self.item, EdgeItem):
            self.item.name = self.oldname  
            if isinstance(self.item, FileNode):
                components=string.split(self.item.fullPath, '/')
                components[-1] = str(self.item.name)
                self.item.fullPath = '/'.join(components)
        else:
            self.item.description = self.oldname
        self.item.scene().update()
            
    def redo(self):
        if not isinstance(self.item, EdgeItem):
            self.oldname = self.item.name
            self.item.name = self.name 

            if isinstance(self.item, FileNode):
                components=string.split(self.item.fullPath, '/')
                components[-1] = str(self.item.name)
                self.item.fullPath = '/'.join(components) 
        else:
            self.oldname = self.item.description
            self.item.description = self.name
        self.item.scene().update()

        