
'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Yifei Li
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on Dec 19, 2011

@author: yifli
'''

from PyQt4.QtGui import QApplication, QDialog
from PyQt4.QtCore import Qt, QCoreApplication
from MainWindow import MainWindow
from Autograde import Autograde
import sys, os
from Ui_Greeting import Ui_Greeting
from DTEForCommandLine import DTEForCommandLine
import warnings


class GreetingWindow(QDialog):
    def __init__(self):
        QDialog.__init__(self)
        self.ui = Ui_Greeting()
        self.ui.setupUi(self)
        flags = Qt.Dialog | Qt.WindowStaysOnTopHint
        self.setWindowFlags(flags)
        self.ui.pushButton.clicked.connect(self.close)

def testwarning():
    print 'before'
    warnings.warn('you are warned!')
    print 'after'
     
def main():
    app = QApplication(sys.argv)
     
    QCoreApplication.setApplicationName('DTEVis')
    QCoreApplication.setApplicationVersion('1.0')
    QCoreApplication.setOrganizationName('CS@MTU')
 
    QApplication.setStyle('plastique')
    app.setStyleSheet("""QToolTip {
                        background-color:white;
                        color:black;
    }""")
    greetWin = GreetingWindow()
    greetWin.show()
     
    window = MainWindow()
    #auto grading
    if len(sys.argv)==5:
        if sys.argv[1]=='-autograde':
            window.ioHelper.import_(sys.argv[2])
            autog = Autograde(sys.argv[2], sys.argv[3], sys.argv[4])
            #commandline DTEvisual -autograde stuSpecfile.dte Answerfile.txt
            #generate a gradeFile.txt
            #all files are in Grading folder
            autog.autograde(sys.argv[2], sys.argv[3], sys.argv[4])
            return
    window.show()
    exitcode = app.exec_()
    sys.exit(exitcode)
 

     
if __name__ == '__main__':
#     dte = DTEForCommandLine()
    main()
    
    
