'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Yifei Li
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on Feb 9, 2012

@author: yifli
'''

from PyQt4.QtGui import QUndoCommand, QMessageBox

class DeleteTypeCommand(QUndoCommand):
    def __init__(self, item):
        QUndoCommand.__init__(self)
        self.item = item
        self.scene = self.item.scene()
        self.affectedChildren = None
        
        
    def undo(self):
        self.item.type = self.oldType
        if self.affectedChildren is not None:
            for n in self.affectedChildren:
                n.type = self.item.type
        self.scene.update()

    
    def redo(self):
        # go up in the tree to find out if it's possible to inherit a type from its ancestors
        self.oldType = self.item.type
        inherited = False
        parent = self.item.parent
        while parent:
            if parent.type is not None:
                self.item.type = parent.type
                inherited = True
                break
            else:
                parent = parent.parent
        if not inherited:
            self.item.type = None
            
        # go down in the tree to look for affected children
        if self.oldType is not self.item.type:
            self.affectedChildren = []
            nodes = [i for i in self.item.children]
            for n in nodes:
                if n.inheritFromNode is not None:
                    n.type = self.item.type
                    self.affectedChildren.append(n)
                if n.children:
                    nodes.extend(n.children)

        
        self.scene.update()

        