'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Yifei Li
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on Dec 20, 2011

@author: yifli
'''

from PyQt4.QtGui import QGraphicsItem, QGraphicsEllipseItem, QBrush, QPen, QColor, QFontMetrics
from PyQt4.QtCore import Qt, QRectF, QObject


class DomainNode(QGraphicsEllipseItem):

    def __init__(self):
        QObject.__init__(self)
        QGraphicsEllipseItem.__init__(self, QRectF(-40,-20,80,40))
        self.setFlag(QGraphicsItem.ItemIsMovable, True)
        self.setFlag(QGraphicsItem.ItemIsSelectable, True)
        self.setFlag(QGraphicsItem.ItemSendsGeometryChanges, True)
        brush = QBrush(QColor(255, 255, 0))
        self.setBrush(brush)
        #self.name = 'Domain'
        self.initialDomain = False
        self.edgeList = []
        self.entryPoints = ''
        self.children = []
        self.parent = None
        self.highlighted = False
        self.highlightColor = QColor(0, 255, 0)
        
    def __setattr__(self, name, value):
        self.__dict__[name] = value
        if name == 'name':
            #object.__setattr__(self, name, value)
            width = QFontMetrics(self.scene().font()).boundingRect(self.name).width()
            if width > self.boundingRect().width():
                self.setToolTip(self.name)

        
    def paint(self, painter, option, widget=None):
        if self.initialDomain:
            pen = QPen(QColor(255, 53, 0))
            pen.setWidth(2.0)
            self.setPen(pen)
        else:
            pen = QPen(QColor(0, 0, 0))
            pen.setWidth(1.0)
            self.setPen(pen)
        QGraphicsEllipseItem.paint(self, painter, option, widget)
        painter.drawText(self.rect(), Qt.AlignCenter, self.name)
        
        if self.highlighted:
            painter.save()
            painter.setPen(QPen(QBrush(self.highlightColor), 2.0))
            painter.setBrush(Qt.NoBrush)
            painter.drawRect(self.rect().adjusted(-5, -5, 5, 5))
            painter.restore()

                
    def itemChange(self, change, value):
        if change == QGraphicsItem.ItemPositionChange:
            for edge in self.edgeList:
                edge.updatePosition()
        return value 
        
    

        