'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Yifei Li
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on Feb 4, 2012

@author: yifli
'''

from PyQt4.QtGui import QUndoCommand
from DomainNode import DomainNode

class MarkInitialDomainCommand(QUndoCommand):
 
    def __init__(self, item, entryPoint, parent = None):
        QUndoCommand.__init__(self, parent)
        self.item = item
        self.olditem = None
        self.entryPoint = entryPoint
        
    def undo(self):
        self.item.initialDomain = False
        if self.olditem is not None:
            self.olditem.initialDomain = True
        self.item.scene().initialDomain = self.olditem
        self.item.scene().update()
        

    def redo(self):
        for item in self.item.scene().items():
            if isinstance(item, DomainNode):
                if item.initialDomain:
                    self.olditem = item
                    self.olditem.initialDomain = False
                    break
        self.item.initialDomain = True
        self.item.entryPoints = self.entryPoint
        self.item.scene().initialDomain = self.item
        self.item.scene().update()
        
        
        