'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Yifei Li
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on Dec 20, 2011

@author: yifli
'''

from PyQt4.QtGui import QGraphicsItem, QGraphicsRectItem, QBrush, QPen, QColor, QFontMetrics
from PyQt4.QtCore import Qt, QRectF, QObject
import re

class TypeNode(QGraphicsRectItem):
    ColorTable = [(0, 0, 128), (34,139,34), (255,255,0), (205,92,92), (255,165,0),
              (255,20,147), (139,136,120), (49,79,79), (30,144,255), (173,255,147),
              (184,134,11), (188,143,143), (255, 0, 0), (221,160,221), (255,218,185),
              (208,32,144), (240,128,128), (210,180,140), (50,205,50), (0,255,255),
              (193,205,193), (255,105,180), (32,178,170), (139,69,19), (238,232,170)]

    counter = 0

    def __init__(self, parent = None):
        QGraphicsRectItem.__init__(self, QRectF(-40,-20,80,40), parent)
        self.setFlag(QGraphicsItem.ItemIsMovable, True)
        self.setFlag(QGraphicsItem.ItemIsSelectable, True)
        self.setFlag(QGraphicsItem.ItemSendsGeometryChanges, True)
        brush = QBrush(QColor(230, 230, 230))
        self.setBrush(brush)
        #self.name = ''  
        self.edgeList = [] 
        self.assignment=''
        self.highlighted = False
        self.highlightColor = QColor(255, 0, 0)
        TypeNode.counter += 1
        
    def __setattr__(self, name, value):
        self.__dict__[name] = value
        if name == 'name':
            width = QFontMetrics(self.scene().font()).boundingRect(self.name).width()
            if width > self.boundingRect().width():
                self.setToolTip(self.name)

                
    def paint(self, painter, option, widget=None):
        if self.scene().domainGraphOnly:
            return
        QGraphicsRectItem.paint(self, painter, option, widget)
        painter.drawText(self.rect(), Qt.AlignCenter, self.name)
        if self.highlighted:
            painter.save()
            painter.setPen(QPen(QBrush(self.highlightColor), 2.0))
            painter.setBrush(Qt.NoBrush)
            painter.drawRect(self.rect().adjusted(-5,-5,5,5))
            painter.restore()

    
          
    def itemChange(self, change, value):
        if change == QGraphicsItem.ItemPositionChange:
            for edge in self.edgeList:
                edge.updatePosition()
        return value
    
                
    '''           
    def itemDeleted(self):
        scene = self.scene()
        for e in self.edgeList:
            self.scene().removeItem(e)
        self.scene().removeItem(self)

            
        scene.update()
    '''
        
            

