'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Yifei Li
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on Feb 12, 2012

@author: yifli
'''

from PyQt4.QtCore import QProcess, QLibraryInfo, QDir, QLatin1String, QByteArray, QString
from PyQt4.QtGui import QMessageBox
import platform

class Assistant(object):
    def __init__(self):
        self.proc = None
        
    def startAssistant(self):
        if self.proc is None:
            self.proc = QProcess()
            
        if self.proc.state() != QProcess.Running:
            app = QLibraryInfo.location(QLibraryInfo.BinariesPath) + QDir.separator()
            if platform.system() == 'Darwin':
                app += QLatin1String("Assistant.app/Contents/MacOS/Assistant")
            else:
                app += QLatin1String("assistant")
            
            args = [QLatin1String("-collectionFile"), QLatin1String("DTEVis.qhc")]
            
            self.proc.start(app, args)
            
            if not self.proc.waitForStarted():
                QMessageBox.critical(None, 'Error', 'Unable to launch Qt Assistant')
                return False
        return True

    def showDocumentation(self, page):
        if not self.startAssistant():
            return
        
        ba = QByteArray("SetSource ")
        ba.append("qthelp://edu.mtu.cs.dtevis/doc/")
        self.proc.write(ba + QString(page).toLocal8Bit() + '\n')
        
        
    def __del__(self):
        if self.proc is not None and self.proc.state() == QProcess.Running:
            self.proc.terminate()
            self.proc.waitForFinished()
        
        
    
            