'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Yifei Li
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on Feb 3, 2012

@author: yifli
'''

from PyQt4.QtGui import QUndoCommand

class ChangeTypeCommand(QUndoCommand):
    '''
    change the type of a file/directory
    '''

    def __init__(self, item, type):
        QUndoCommand.__init__(self)
        self.type = type
        self.item = item
        self.affectedNodes = None
       
    def undo(self):
        self.item.type = self.oldtype
        if self.affectedNodes:
            for n in self.affectedNodes:
                n.type = self.oldtype
        self.item.scene().update()
    
    def redo(self):
        self.oldtype = self.item.type
        self.item.type = self.type
        self.affectedNodes = []
        nodes = [i for i in self.item.children]
        for n in nodes:
            if n.inheritFromNode is not None:
                n.type = self.type
                self.affectedNodes.append(n)
            if n.children:
                nodes.extend(n.children)
                
        self.item.scene().update()
         