'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Yifei Li
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on Feb 5, 2012

@author: yifli
'''

from PyQt4.QtGui import QDialog, QInputDialog, QMessageBox
from TypeNode import TypeNode
from Ui_TypeChooser import Ui_Dialog
import random

class TypeChooserDialog(QDialog):
    def __init__(self, scene):
        QDialog.__init__(self)
        self.ui = Ui_Dialog()
        self.ui.setupUi(self)
        self.scene = scene
        self.ui.newTypePushButton.clicked.connect(self.addNewType)
        
    
    def addNewType(self):
        name, accept = QInputDialog.getText(self, 'Set Type Node Name', '', text='')
        if accept:
            if name.isEmpty():
                QMessageBox.critical(self.views()[0], 'Error', 'Type name cannot be empty')
                return
            for item in self.scene.items():
                if isinstance(item, TypeNode):
                    if str(name) == str(item.name):
                        QMessageBox.critical(self.rightClickedItem.parentWidget(), 'Error', 'A type with the same name already exists')
                        return
            self.ui.typeComboBox.addItem(name)
            self.ui.typeComboBox.setCurrentIndex(self.ui.typeComboBox.count()-1)
            node = TypeNode()
            print node.counter
            if node.counter >= len(TypeNode.ColorTable):
                pass
            else:
                node.color = TypeNode.ColorTable[node.counter]
            node.setPos(2800, 2800)
            self.scene.nodeAdded.emit(node, name)
    

        