'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Yifei Li
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on Feb 4, 2012

@author: yifli
'''

from PyQt4.QtGui import QUndoCommand, QMessageBox

class ChangeFlagCommand(QUndoCommand):
    '''
    Change the flag of an assignment
    '''
 
    def __init__(self, item, flag, parent = None):
        QUndoCommand.__init__(self, parent)
        self.flag = flag
        self.item = item
        self.oldflag = self.item.flag
        self.affectedNodes = None
        if self.flag == 2 or self.flag == 3 and self.oldflag == 0 or self.oldflag == 1:
            self.removeRecursive = False
        elif self.flag == 0 or self.flag == 1 and self.oldflag == 2 or self.oldflag == 3:
            self.removeRecursive = True
        
        
    def undo(self):
        self.item.flag = self.oldflag
        self.item.scene().update()
        
    
    def redo(self):
        self.item.flag = self.flag
        self.item.scene().update()

        
                    
                    
                   