'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Yifei Li
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on Jan 20, 2012

@author: yifli
'''
from PyQt4.QtGui import QGraphicsEllipseItem, QColor, QPen, QBrush
from PyQt4.QtCore import  Qt

class FileNode(QGraphicsEllipseItem):
 
    def __init__(self, name, type, flag):
        QGraphicsEllipseItem.__init__(self)
        self.setRect(-5,-5,10,10)
        self.type = type
        self.name = name
        self.flag = flag
        self.fullPath = ''
        self.children = []
        self.parent = None
        self.edgeList = []
        self.inheritFromNode = None
        self.highlighted = False
        
    
    def paint(self, painter, option, widget=None):
        if self.type is None:
            self.setBrush(QColor(0, 0, 0))
        else:
            self.setBrush(QColor(self.type.color[0], self.type.color[1], self.type.color[2]))

        font = self.scene().font()
        font.setPixelSize(15)
        painter.setFont(font)
        QGraphicsEllipseItem.paint(self, painter, option, widget)
        x = int(self.rect().topLeft().x())
        y = int(self.rect().topLeft().y()-20)
        if self.flag == 2 or self.flag == 3:  
            rect = painter.fontMetrics().boundingRect(self.name+'/')
            rect.moveTo(x, y)
            painter.drawText(rect, Qt.AlignCenter, self.name+'/')
	    if self.flag == 3:
	    	    painter.drawArc(self.rect().adjusted(-5, -5, 5, 5,), 0, 5760)
        else:
            rect = painter.fontMetrics().boundingRect(self.name)
            rect.moveTo(x, y)
            painter.drawText(rect, Qt.AlignCenter, self.name)
	    if self.flag == 1:
	    	painter.drawArc(self.rect().adjusted(-5, -5, 5, 5,), 0, 5760)
	    	
        if self.highlighted:
            painter.save()
            painter.setPen(QPen(QBrush(QColor(255, 0, 0)), 2.0))
            painter.setBrush(Qt.NoBrush)
            painter.drawRect(self.rect().adjusted(-5, -5, 5, 5))
            painter.restore()


            
        
                     
            
