'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Yifei Li
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on Feb 5, 2012

@author: yifli
'''

from PyQt4.QtGui import QDialog
from PyQt4.QtCore import Qt
from Ui_FlagChooser import Ui_flagDialog


class FlagChooserDialog(QDialog):

    def __init__(self):
        QDialog.__init__(self)
        self.ui = Ui_flagDialog()
        self.ui.setupUi(self)
                            
            
    def myExec(self, item):
        if item.flag == 0:
            self.ui.rCheckBox.setChecked(False)
            self.ui.sCheckBox.setChecked(False)
        elif item.flag == 1:
            self.ui.rCheckBox.setChecked(False)
            self.ui.sCheckBox.setChecked(True)
        elif item.flag == 2:
            self.ui.rCheckBox.setChecked(True)
            self.ui.sCheckBox.setChecked(False)
        elif item.flag == 3:
            self.ui.rCheckBox.setChecked(True)
            self.ui.sCheckBox.setChecked(True)

        if item.flag == 2 or item.flag == 3:
            if item.children:  # cannot remove -r from directory
                self.ui.rCheckBox.setDisabled(True)
            else:
                self.ui.rCheckBox.setEnabled(True)
        
        # cannot add '-s' if there exists a child of different type        
        nodes = [i for i in item.children]
        self.ui.sCheckBox.setEnabled(True)
        for n in nodes:
            if n.type is not item.type:
                self.ui.sCheckBox.setDisabled(True)
                break
            if n.children:
                nodes.extend(n.children)
                
        
        
        QDialog.exec_(self)

                
        