'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Yifei Li
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on Dec 20, 2011

@author: yifli
'''
from PyQt4.QtGui import QUndoCommand

class MoveCommand(QUndoCommand):

    def __init__(self, item, oldPos, scene, parent=None):
        QUndoCommand.__init__(self, parent)
        self.item = item
        self.newPos = self.item.pos()
        self.oldPos = oldPos
        self.scene = scene  
        
    def undo(self):
        self.item.setPos(self.oldPos)
        self.scene.update()
    
    def redo(self):
        self.item.setPos(self.newPos)
        self.scene.update()
