'''
Accessible Access Control 1.0
2012-2104 Michigan Technological University
Supported in part by NSF grants: DUE-1140512, DUE-1245310 and IIS-1319363
Developer: Yifei Li
Advisors:Dr. Steve Carr, Dr. Jean Mayo, Dr. Ching-Kuang Shene and Dr. Chaoli Wang
'''
'''
Created on Feb 5, 2012

@author: yifli
'''

from PyQt4.QtGui import QDialog, QInputDialog, QMessageBox
from PyQt4.QtCore import Qt
from TypeNode import TypeNode
from Ui_NewFileNodeDialog import Ui_Dialog
import string

class NewFileNodeDialog(QDialog):
 
    def __init__(self, scene):
        QDialog.__init__(self)
        self.ui = Ui_Dialog()
        self.ui.setupUi(self)
        self.scene = scene
        
        self.ui.newTypePushButton.clicked.connect(self.addNewType)
    
    def myExec(self, item):
        parent = item.parent
        staticParent = False
        while parent:
            if parent.flag == 3:
                self.ui.typeComboBox.setDisabled(True)
                self.ui.newTypePushButton.setDisabled(True)
                staticParent = True
                break
            parent = parent.parent
            
        if not staticParent:
            self.ui.typeComboBox.setEnabled(True)
            self.ui.newTypePushButton.setEnabled(True)
            self.ui.typeComboBox.clear()
            for item in self.scene.items():  
                if isinstance(item, TypeNode):
                    self.ui.typeComboBox.addItem(item.name)
                
                
        QDialog.exec_(self)
        
            

    def addNewType(self):
        name, accept = QInputDialog.getText(self, 'Set Type Node Name', '', text='')
        if accept:
            if name.isEmpty():
                QMessageBox.critical(self.views()[0], 'Error', 'Type name cannot be empty')
                return
            name = string.strip(str(name))
            for item in self.scene.items():
                if isinstance(item, TypeNode):
                    if name == item.name:
                        QMessageBox.critical(self.rightClickedItem.parentWidget(), 'Error', 'A type with the same name already exists')
                        return
            self.ui.typeComboBox.addItem(name)
            node = TypeNode()
            if node.counter >= len(TypeNode.ColorTable):
                pass
            else:
                node.color = TypeNode.ColorTable[node.counter]
            node.setPos(2800, 2800)
            self.scene.nodeAdded.emit(node, name)

