'''
Created on May 30, 2014

@author: mandy
'''
from PyQt4.QtGui import QGraphicsItem, QPainter, QPen, QBrush, QGraphicsEllipseItem, QPainterPath, QTransform, QFont
from PyQt4.QtCore import Qt, QLineF, QPointF, QRectF, QString
import math

class BlockingCircleNode(QGraphicsEllipseItem):
    def __init__(self, rect, angleStart, angleSpan):
        QGraphicsEllipseItem.__init__(self)
        self.paintColor = Qt.white
        self.setAcceptHoverEvents(False)
        self.setFlag(QGraphicsItem.ItemIsMovable, False)
        self.setFlag(QGraphicsItem.ItemIsSelectable, False)
        self.setVisible(False)
        self.setRect(rect)
        self.setStartAngle(angleStart)
        self.setSpanAngle(angleSpan)
        self.edgeList = []
    
    def setPosition(self, rect, angleStart, angleSpan):
        self.setRect(rect)
        self.setStartAngle(angleStart)
        self.setSpanAngle(angleSpan)
        
    def paint(self, painter, option, widget):
        self.setPen(self.paintColor)
        self.setBrush(self.paintColor)
        painter.setRenderHint(QPainter.Antialiasing, True)
        QGraphicsEllipseItem.paint(self, painter, option, widget)
        
class EdgeBundleLabelNode(QGraphicsEllipseItem):
    CIRCLELAYOUT_RECTINTVEL = 30
    PI = 3.14159
    DEGREE2RADIAN = PI/180
    
    def __init__(self, scene, text, fullPath):
        '''
        Constructor
        '''
        QGraphicsEllipseItem.__init__(self)
        #self.setFlag(QGraphicsItem.ItemIsSelectable)
        self.highlighted = False
        self.lineWidth = 1.0
        #self.color = QColor(0,0,0,255)
        self.highlightColor = Qt.red
        self.color = Qt.black
        self.setVisible(False)
        self.text = text
        self.fullPath = fullPath
        self.scene = scene
        self.center = self.scene.main.center
        self.setAcceptHoverEvents(True)
        
    def setPosition(self, rect, angleStart, angleSpan):
        self.rect = rect
        self.setRect(self.rect)
        radius = 0.5*rect.width()
        self.angleStart = angleStart
        self.angleSpan = angleSpan
        self.setStartAngle(self.angleStart)
        self.setSpanAngle(self.angleSpan)
#         angleStart /= 16
#         angleSpan /= 16
        angleStart = -angleStart*self.DEGREE2RADIAN
        angle = angleStart-(angleSpan)*self.DEGREE2RADIAN
        halfAngle = angleStart-(0.5*angleSpan)*self.DEGREE2RADIAN
        
        self.pointLeftTop = QPointF(radius*math.cos(angleStart)+self.center.x(), radius*math.sin(angleStart)+self.center.y())
        self.pointLeftBottom = QPointF((radius-self.CIRCLELAYOUT_RECTINTVEL)*math.cos(angleStart)+self.center.x(), (radius-self.CIRCLELAYOUT_RECTINTVEL)*math.sin(angleStart)+self.center.y())
        self.pointRightTop = QPointF(radius*math.cos(angle)+self.center.x(), radius*math.sin(angle)+self.center.y())
        self.pointRightBottom = QPointF((radius-self.CIRCLELAYOUT_RECTINTVEL)*math.cos(angle)+self.center.x(), (radius-self.CIRCLELAYOUT_RECTINTVEL)*math.sin(angle)+self.center.y())
        self.pointMiddle = QPointF((radius-0.5*self.CIRCLELAYOUT_RECTINTVEL)*math.cos(halfAngle)+self.center.x(), (radius-0.5*self.CIRCLELAYOUT_RECTINTVEL)*math.sin(halfAngle)+self.center.y())
        self.pointLeftMiddle = QPointF((radius-0.7*self.CIRCLELAYOUT_RECTINTVEL)*math.cos(angle)+self.center.x(), (radius-0.7*self.CIRCLELAYOUT_RECTINTVEL)*math.sin(angle)+self.center.y())
        self.pointBottomMiddle = QPointF((radius-self.CIRCLELAYOUT_RECTINTVEL)*math.cos(halfAngle)+self.center.x(), (radius-self.CIRCLELAYOUT_RECTINTVEL)*math.sin(halfAngle)+self.center.y())
    
    def drawLabel(self, painter, text):
            text = QString(text)
            width = self.scene.sceneRect().width()
            height = self.scene.sceneRect().height()
            drawWidth = width / 100
            pen = painter.pen()
            pen.setWidth(drawWidth)
            pen.setColor(Qt.darkGreen)
            painter.setPen(pen)
     
            path = QPainterPath()
            #rect = QRectF(self.rect.x()+self.CIRCLELAYOUT_RECTINTVEL, self.rect.y()+self.CIRCLELAYOUT_RECTINTVEL, self.rect.width()-2*self.CIRCLELAYOUT_RECTINTVEL, self.rect.height()-2*self.CIRCLELAYOUT_RECTINTVEL)
            rect = QRectF(self.rect.x()+0.7*self.CIRCLELAYOUT_RECTINTVEL, self.rect.y()+0.7*self.CIRCLELAYOUT_RECTINTVEL, self.rect.width()-1.4*self.CIRCLELAYOUT_RECTINTVEL, self.rect.height()-1.4*self.CIRCLELAYOUT_RECTINTVEL)
            path.moveTo(self.pointLeftMiddle)
            path.arcTo(rect, self.angleStart+self.angleSpan, -self.angleSpan)
            #path.arcTo(rect, self.angleStart/16+self.angleSpan/16, -self.angleSpan/16)
            #path.cubicTo(c1, c2, QPointF(width, height))
            #draw the bezier curve
            #painter.drawPath(path)
     
            #Make the painter ready to draw chars
            font = QFont("font: Courier", 12, QFont.System)#painter.font()
            font.setPixelSize(17)#drawWidth*2)
            painter.setFont(font)
            pen.setColor(Qt.black)
            painter.setPen(pen)
     
            percentIncrease = 1.0/(text.size()+3)
            percent = 0.0
     
            for i in xrange(text.size()):
                percent += percentIncrease
     
                point = path.pointAtPercent(percent)#(0.4)
                angle = -path.angleAtPercent(percent)#(0.4)
     
                rad = (0.017453292519943295769)*angle # PI/180
         
    #             // From the documentation:
    #             /**
    #               QTransform transforms a point in the plane to another point using the following formulas:
    #               x' = m11*x + m21*y + dx
    #               y' = m22*y + m12*x + dy
    #             **/
    #             // So the idea is to find the "new position of the character
    #             // After we apply the world rotation.
    #             // Then translate the painter back to the original position.
                sina = math.sin(rad)
                cosa = math.cos(rad)
     
    #             // Finding the delta for the penwidth
    #             // Don't divide by 2 because some space would be nice
                deltaPenX = cosa * pen.width()
                deltaPenY = sina * pen.width()
                #Finding new posision after rotation
                newX = (cosa * point.x()) - (sina * point.y())
                newY = (cosa * point.y()) + (sina * point.x())
     
                #Getting the delta distance
                deltaX = newX - point.x()
                deltaY = newY - point.y()
                #Applying the rotation with the translation.
                tran = QTransform(cosa,sina,-sina,cosa,-deltaX + deltaPenX,-deltaY - deltaPenY)
                #tran = QTransform(1,0,0,1,-deltaX + deltaPenX,-deltaY - deltaPenY)
                #tran = QTransform(cosa,sina,-sina,cosa,-deltaX,-deltaY)
                painter.setWorldTransform(tran)
                #painter.drawText(point, text)
                painter.drawText(point,QString(text[i]))
                
    def paint(self, painter, option, widget = None):
        pen = QPen(self.color)
        pen.setWidth(self.lineWidth)
        painter.setPen(pen)
        #painter.setBrush(QBrush(Qt.red))
        painter.setRenderHint(QPainter.HighQualityAntialiasing, True)
        
        path = QPainterPath()
        path.moveTo(self.pointLeftTop)
        path.arcTo(self.rect, self.angleStart, self.angleSpan)
        #path.arcTo(self.rect, self.angleStart/16, self.angleSpan/16)
        path.moveTo(self.pointRightBottom)
        rect = QRectF(self.rect.x()+self.CIRCLELAYOUT_RECTINTVEL, self.rect.y()+self.CIRCLELAYOUT_RECTINTVEL, self.rect.width()-2*self.CIRCLELAYOUT_RECTINTVEL, self.rect.height()-2*self.CIRCLELAYOUT_RECTINTVEL)
        path.arcTo(rect, self.angleStart+self.angleSpan, -self.angleSpan)
        #path.arcTo(rect, self.angleStart/16+self.angleSpan/16, -self.angleSpan/16)
        path.lineTo(self.pointLeftTop)
        #path.closeSubpath()
        painter.drawPath(path)
        
        
#         painter.drawLine(QLineF(self.pointLeftBottom, self.pointLeftTop))
#         painter.drawLine(QLineF(self.pointRightBottom, self.pointRightTop))

#         center = QPointF(0.5*self.sceneRect().width(), 0.5*self.sceneRect().height())
#         if center.x() > center.y():
#             radius = center.y()-4
#             rect = QRectF(center.x()-radius, 2, 2*radius, 2*radius)
#         else:
#             radius = center.x()-4
#             rect = QRectF(2, 2, 2*radius, 2*radius)
        #No.1 Circle
#         painter.drawArc(self.rect, self.angleStart, self.angleSpan)
#         #No.2 Circle
#         rect = QRectF(self.rect.x()+self.CIRCLELAYOUT_RECTINTVEL, self.rect.y()+self.CIRCLELAYOUT_RECTINTVEL, self.rect.width()-2*self.CIRCLELAYOUT_RECTINTVEL, self.rect.height()-2*self.CIRCLELAYOUT_RECTINTVEL)
#         painter.drawArc(rect, self.angleStart, self.angleSpan)
        #QGraphicsEllipseItem.paint(self, painter, option, widget)
        self.drawLabel(painter, self.text)
        