'''
Created on Jul 27, 2014

@author: Mandy
'''
from PyQt4.QtGui import QGraphicsRectItem, QFont, QPen, QPainter
from PyQt4.QtCore import Qt
from DirNode import DirNode
from RoleNode import RoleCompactNode
from UserNode import UserNode

class LegendItem(QGraphicsRectItem):
    
    def __init__(self, main, posx, posy, text, lineColor, color):
        QGraphicsRectItem.__init__(self)
        self.font = QFont('Calibri')
        self.font.setPixelSize(15)
        self.label = text
        self.lineColor = lineColor
        self.color = color
        self.pen = QPen()
        self.setPos(posx, posy)
    
    def paint(self, painter, option, widget=None):
        '''
        draw outline
        '''
        self.pen.setColor(self.lineColor)
        self.pen.setWidth(2.0)
        self.setPen(self.pen)
        self.setBrush(self.color)
        painter.setRenderHint(QPainter.Antialiasing, True)
        QGraphicsRectItem.paint(self, painter, option, widget)
        '''
        display name as label
        '''
        self.pen.setColor(Qt.black)
        painter.setPen(self.pen)
        painter.setFont(self.font)
        self.labelRect = painter.fontMetrics().boundingRect(self.label)
        x = int(self.rect().bottomRight().x())
        y = int(self.rect().bottomRight().y()+0.5*self.labelRect.height())
        self.paintLabel(painter, self.brush, x, y)
                
    def paintLabel(self, painter, oldbrush, x, y):
        rect = self.labelRect
        rect.moveTo(x, y)
        painter.drawText(rect, Qt.AlignLeft, self.label)
        