'''
Created on Aug 13, 2014

@author: mandy
'''
from PyQt4 import QtCore, QtGui

try:
    _fromUtf8 = QtCore.QString.fromUtf8
except AttributeError:
    _fromUtf8 = lambda s: s

class Ui_QuizModeSelectionDlg(object):
    QUIZ_TRADITIONAL = 0
    QUIZ_TRYING = 1
    QUIZ_SHOWANSWER = 2
    
    def setupUi(self, Dialog):
        Dialog.setObjectName(_fromUtf8("Dialog"))
        Dialog.setWindowTitle('Quiz Mode Setting')
        Dialog.resize(500, 300)
        font = QtGui.QFont()
        font.setPointSize(12)
        Dialog.setFont(font)
        self.verticalLayoutWidget = QtGui.QWidget(Dialog)
        noticeLabel = QtGui.QLabel('Please choose a quiz mode from the following:')
        noticeLabel.setWordWrap(True)
        self.modeRBtn1 = QtGui.QRadioButton()
        self.modeRBtn2 = QtGui.QRadioButton()
        self.modeRBtn3 = QtGui.QRadioButton()
        TRADITION_MODE_TEXT = 'Traditional quiz mode with your answers emailed to instructor'
        TRYING_MODE_TEXT = 'Activate next question until current one is correctly answered'
        SHOWANSWER_MODE_TEXT = 'Show correct answer after answering each question'
        self.modeRBtn1.setText(TRADITION_MODE_TEXT)
        self.modeRBtn2.setText(TRYING_MODE_TEXT)
        self.modeRBtn3.setText(SHOWANSWER_MODE_TEXT)
#         modeRBtnLabel = QtGui.QLabel(TRADITION_MODE_TEXT)
#         geometry = self.modeRBtn1.geometry()
#         modeRBtnLabel.setGeometry(geometry.x()+geometry.width()+5, geometry.y(), modeRBtnLabel.geometry().width(), modeRBtnLabel.geometry().height())
#         modeRBtnLabel.setWordWrap(True)
#         modeRBtnLabe2 = QtGui.QLabel(TRYING_MODE_TEXT)
#         geometry = self.modeRBtn2.geometry()
#         modeRBtnLabe2.setGeometry(geometry.x()+geometry.width()+5, geometry.y(), modeRBtnLabe2.geometry().width(), modeRBtnLabe2.geometry().height())
#         modeRBtnLabe2.setWordWrap(True)
#         modeRBtnLabe3 = QtGui.QLabel(SHOWANSWER_MODE_TEXT)
#         geometry = self.modeRBtn3.geometry()
#         modeRBtnLabe3.setGeometry(geometry.x()+geometry.width()+5, geometry.y(), modeRBtnLabe3.geometry().width(), modeRBtnLabe3.geometry().height())
#         modeRBtnLabe3.setWordWrap(True)
        self.explainLabel = QtGui.QLabel()
        self.explainLabel.setWordWrap(True)
        self.explainLabel.setText('No answer is provided throughout the quiz.')
        self.modeRBtn1.clicked.connect(self.changeExplanationBasedOnChoice)
        self.modeRBtn2.clicked.connect(self.changeExplanationBasedOnChoice)
        self.modeRBtn3.clicked.connect(self.changeExplanationBasedOnChoice)
        self.okBtn = QtGui.QPushButton('OK')
        self.cancelBtn = QtGui.QPushButton('Cancel')
        vlayout = QtGui.QVBoxLayout(self.verticalLayoutWidget)
        vlayout.addWidget(noticeLabel)
        vlayout.addWidget(self.modeRBtn1)
        vlayout.addWidget(self.modeRBtn2)
        vlayout.addWidget(self.modeRBtn3)
        vlayout.addWidget(self.explainLabel)
        hwidget = QtGui.QWidget()
        hlayout = QtGui.QHBoxLayout()
        hlayout.addWidget(self.cancelBtn)
        hlayout.addWidget(self.okBtn)
        hlayout.setMargin(0)
        hwidget.setLayout(hlayout)
        vlayout.addWidget(hwidget)
        vlayout.setMargin(30)
        self.vlayout = vlayout
        self.quizmode = self.QUIZ_TRADITIONAL
        self.modeRBtn1.setChecked(True)
    
    def changeExplanationBasedOnChoice(self):
        if self.modeRBtn1.isChecked():
            self.quizmode = self.QUIZ_TRADITIONAL
            self.explainLabel.setText('No answer is provided throughout the quiz. Your answers will be sent to instructor via email.')
        elif self.modeRBtn2.isChecked():
            self.quizmode = self.QUIZ_TRYING
            self.explainLabel.setText('You will have to keep trying until the correct choice is chosen in order to move to the next question. \
                                        Your completion of the quiz will be sent to instructor via email.')
        elif self.modeRBtn3.isChecked():
            self.quizmode = self.QUIZ_SHOWANSWER
            self.explainLabel.setText('Answer will be provided after clicking on the "Answer" button. This mode is good for self-test.')
        
        